---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：333-OAuth認可完了

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **OOBリダイレクトURIの判定ロジック**：Doorkeeper gem内部
  2. **認可コード有効期限のデフォルト値**：設定ファイル未確認
  3. **認可コードの一度きり使用制限**：Doorkeeper gem内部

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/doorkeeper/authorizations/show.html.haml`
- E-02: `app/controllers/oauth/authorizations_controller.rb`
- E-03: `config/initializers/doorkeeper.rb`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面は認可コードを表示する | E-01 (行3: params[:code]) | ○ |
| C-02 | ページタイトルは「Authorization code:」 | E-01 (行1) | ○ |
| C-03 | 認可コードはcodeタグで表示 | E-01 (行3) | ○ |
| C-04 | mainロールが設定される | E-01 (行2) | ○ |
| C-05 | PageHeadingComponentが使用される | E-01 (行1) | ○ |
| C-06 | verify_confirmed_email!が実行される | E-02 (行14) | ○ |
| C-07 | verify_admin_allowed!が実行される | E-02 (行14) | ○ |
| C-08 | pre_authで認可可能性を判定 | E-02 (行25) | ○ |
| C-09 | 認可不可の場合errorテンプレート表示 | E-02 (行38-39) | ○ |
| C-10 | layoutは'minimal' | E-02 (行20) | ○ |
| C-11 | レイアウトfalseでリダイレクト表示 | E-02 (行30) | ○ |
| C-12 | 監査ログが記録される | E-02 (行44-61) | ○ |
| C-13 | session[:user_return_to]が削除される | E-02 (行29) | ○ |
| C-14 | ログインユーザーのみアクセス可能 | E-03 (行13-25: resource_owner_authenticator) | ○ |
| C-15 | コピーボタンは実装されていない | E-01 (ボタン要素なし) | ○ |
| C-16 | 関連機能No.88はOAuth2プロバイダ | E-05 | ○ |
| C-17 | 認可コード有効期限は10分 | **根拠なし** | △ |
| C-18 | 認可コードは1回のみ使用可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17: 認可コード有効期限の設定値
  - 候補：doorkeeper.rb設定 / Doorkeeper gem デフォルト設定 / OAuth2仕様
- C-18: 認可コードの使用回数制限
  - 候補：Doorkeeper gem内部実装 / OAuth2仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構造はシンプルで明確
- 1: 中リスク - OOBフローの動作条件はDoorkeeper依存
- 0: 低リスク - セキュリティ上の問題は認可コードの短い有効期限で緩和

## 6) レビュアーチェックリスト（最小）
- [ ] OOBリダイレクトURIの判定条件の確認
- [ ] 認可コード有効期限の設定値確認
- [ ] コピーボタン追加の検討（UX改善）
- [ ] 認可コード表示のアクセシビリティ確認
