---
generated_at: 2026-01-22 10:38:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：334-OAuth認可エラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **エラーメッセージの完全なリスト**：Doorkeeper gem内部
  2. **エラーコードとHTTPステータスの対応**：未確認
  3. **国際化対応の状況**：i18nファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/doorkeeper/authorizations/error.html.haml`
- E-02: `app/controllers/oauth/authorizations_controller.rb`
- E-03: `config/initializers/doorkeeper.rb`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はエラー内容を表示する | E-01 (行3) | ○ |
| C-02 | ページタイトルは「An error has occurred」 | E-01 (行1) | ○ |
| C-03 | エラー詳細はpreタグで表示 | E-01 (行3) | ○ |
| C-04 | mainロールが設定される | E-01 (行2) | ○ |
| C-05 | @pre_auth.error_response.body[:error_description]を表示 | E-01 (行3) | ○ |
| C-06 | pre_auth.authorizable?がfalseでエラー表示 | E-02 (行37-39) | ○ |
| C-07 | verify_confirmed_email!でメール未確認チェック | E-02 (行143-148) | ○ |
| C-08 | unconfirmed_emailエラーが設定される | E-02 (行146) | ○ |
| C-09 | validate_pkce_for_dynamic_applicationsでPKCEチェック | E-02 (行167-180) | ○ |
| C-10 | pkce_required_for_dynamic_applicationsエラー | E-02 (行171-172) | ○ |
| C-11 | invalid_code_challenge_methodエラー | E-02 (行178-179) | ○ |
| C-12 | layoutは'minimal' | E-02 (行20) | ○ |
| C-13 | verify_admin_allowed!でforbidden表示分岐 | E-02 (行150-152) | ○ |
| C-14 | 関連機能No.88はOAuth2プロバイダ | E-05 | ○ |
| C-15 | PageHeadingComponentが使用される | E-01 (行1) | ○ |
| C-16 | データベース更新なし | E-01, E-02 (DB操作コードなし) | ○ |
| C-17 | ログインユーザー・未ログイン両方に表示される | E-02 (行143: current_user&.confirmed?) | ○ |
| C-18 | 動的アプリはPKCE必須 | E-02 (行167-168) | ○ |
| C-19 | invalid_clientエラーメッセージ | **根拠なし** | △ |
| C-20 | invalid_redirect_uriエラーメッセージ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-19, C-20: OAuth2.0標準エラーメッセージの詳細
  - 候補：Doorkeeper gem エラーメッセージ定義 / OAuth2.0仕様 RFC 6749 / i18nファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構造はシンプルで明確
- 1: 中リスク - エラーメッセージの完全性はDoorkeeper gem依存
- 0: 低リスク - セキュリティ上の問題はなし

## 6) レビュアーチェックリスト（最小）
- [ ] Doorkeeper gemのエラーメッセージ一覧の確認
- [ ] エラーメッセージの国際化対応状況確認
- [ ] エラー画面のアクセシビリティ確認
- [ ] エラーメッセージがユーザーフレンドリーか確認
