---
generated_at: 2026-01-22 10:42:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：335-OAuth認可禁止

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **API経由での設定変更方法の詳細**：APIドキュメント未確認
  2. **trustedアプリケーションの判定条件**：要確認
  3. **管理者モードとの関係**：追加確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/doorkeeper/authorizations/forbidden.html.haml`
- E-02: `app/controllers/oauth/authorizations_controller.rb`
- E-03: `config/initializers/doorkeeper.rb`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面は「Forbidden」と表示する | E-01 (行1) | ○ |
| C-02 | 警告アイコンが表示される | E-01 (行4: sprite_icon('warning-solid')) | ○ |
| C-03 | 禁止スコープ一覧がメッセージに含まれる | E-01 (行5) | ○ |
| C-04 | mainロールが設定される | E-01 (行2) | ○ |
| C-05 | verify_admin_allowed!がbefore_actionで呼ばれる | E-02 (行14) | ○ |
| C-06 | disallow_connect?で禁止判定 | E-02 (行150-152) | ○ |
| C-07 | current_user.admin?がチェックされる | E-02 (行156) | ○ |
| C-08 | Gitlab::CurrentSettings.disable_admin_oauth_scopesがチェックされる | E-02 (行156) | ○ |
| C-09 | dangerous_scopes?がチェックされる | E-02 (行156) | ○ |
| C-10 | API_SCOPE, READ_API_SCOPEが危険スコープ | E-02 (行161) | ○ |
| C-11 | ADMIN_SCOPESが危険スコープ | E-02 (行162) | ○ |
| C-12 | REPOSITORY_SCOPESが危険スコープ | E-02 (行163) | ○ |
| C-13 | REGISTRY_SCOPESが危険スコープ | E-02 (行163) | ○ |
| C-14 | trustedアプリケーションは対象外 | E-02 (行164: !trusted?) | ○ |
| C-15 | layoutは'minimal' | E-02 (行20) | ○ |
| C-16 | html_safeでHTMLタグを有効化 | E-01 (行5) | ○ |
| C-17 | codeタグでスコープ名を強調 | E-01 (行5) | ○ |
| C-18 | disable_admin_oauth_scopes設定変更はAPI経由 | E-01 (行5のメッセージ) | ○ |
| C-19 | 関連機能No.88はOAuth2プロバイダ | E-05 | ○ |
| C-20 | 管理者ユーザーのみに表示される | E-02 (行156) | ○ |
| C-21 | PageHeadingComponentが使用される | E-01 (行1) | ○ |
| C-22 | UI経由でdisable_admin_oauth_scopes設定変更は不可 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-22: UI経由での設定変更不可の詳細
  - 候補：Admin Area設定画面のコード / ApplicationSetting編集フォーム / APIドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - セキュリティ機能として適切に実装されている
- 1: 中リスク - 設定変更方法の文書化が十分か確認
- 0: 低リスク - 画面構造はシンプルで明確

## 6) レビュアーチェックリスト（最小）
- [ ] trustedアプリケーションの判定条件と設定方法の確認
- [ ] API経由でのdisable_admin_oauth_scopes設定変更方法の確認
- [ ] 管理者モード有効時の動作確認
- [ ] メッセージの国際化対応状況確認
