---
generated_at: 2026-01-22 10:46:00
metrics:
  claims_total: 21
  claims_with_evidence: 20
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：336-OAuthリダイレクト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：20 / 21、根拠なし：1
- 優先レビュー（高）
  1. **URLフラグメント引き継ぎの目的・ユースケース**：追加確認推奨
  2. **CSP form-action動的追加の影響**：セキュリティ観点で確認
  3. **skip_authorizationの詳細条件**：Doorkeeper内部実装

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/doorkeeper/authorizations/redirect.html.haml`
- E-02: `app/controllers/oauth/authorizations_controller.rb`
- E-03: `config/initializers/doorkeeper.rb`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面は「Redirecting」と表示する | E-01 (行1) | ○ |
| C-02 | 手動リダイレクト用リンクがある | E-01 (行4) | ○ |
| C-03 | JavaScriptで自動リダイレクトする | E-01 (行6-20) | ○ |
| C-04 | フラグメントパターンは`^#[\w-]+$` | E-01 (行10) | ○ |
| C-05 | window.locationでリダイレクト実行 | E-01 (行19) | ○ |
| C-06 | layoutはfalse | E-02 (行30) | ○ |
| C-07 | redirect_uriがlocalsで渡される | E-02 (行30) | ○ |
| C-08 | skip_authorization?で自動認可判定 | E-02 (行26) | ○ |
| C-09 | matching_token?でトークン一致判定 | E-02 (行26) | ○ |
| C-10 | Confidentialアプリで自動認可が有効 | E-02 (行26: application.confidential?) | ○ |
| C-11 | session[:user_return_to]が削除される | E-02 (行29) | ○ |
| C-12 | allow_redirect_uri_form_actionでCSP更新 | E-02 (行68-76) | ○ |
| C-13 | form-actionにリダイレクトスキーム追加 | E-02 (行74-75) | ○ |
| C-14 | forbid_redirect_uriで危険スキームをブロック | E-03 (行83) | ○ |
| C-15 | data/vbscript/javascriptスキームが禁止 | E-03 (行83) | ○ |
| C-16 | PageHeadingComponentが使用される | E-01 (行1) | ○ |
| C-17 | 認可コード生成はリダイレクト前に完了 | E-02 (行27) | ○ |
| C-18 | 関連機能No.88はOAuth2プロバイダ | E-05 | ○ |
| C-19 | リダイレクト先に既存フラグメントあれば追加しない | E-01 (行15) | ○ |
| C-20 | IIFEで即時実行 | E-01 (行8, 20) | ○ |
| C-21 | SPAアプリのステート保持にフラグメント使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-21: URLフラグメント引き継ぎの具体的なユースケース
  - 候補：OAuth2.0仕様 / SPA認証パターンのドキュメント / GitLab連携アプリの実装例

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JavaScriptコードはシンプルで明確
- 1: 中リスク - フラグメントパターンの安全性は十分か要確認
- 1: 中リスク - CSP form-action動的追加のセキュリティ影響

## 6) レビュアーチェックリスト（最小）
- [ ] フラグメントパターン `^#[\w-]+$` の安全性確認
- [ ] CSP form-action動的追加の影響範囲確認
- [ ] skip_authorization条件の詳細確認
- [ ] JavaScriptが無効な環境での動作確認
