---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：337-デバイス認可

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **デバイスグラントテーブルの構造**：Doorkeeper gem内部
  2. **ポーリングによるトークン取得の詳細**：Doorkeeper gem内部
  3. **ユーザーコードの有効期限設定**：設定ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/doorkeeper/device_authorization_grant/authorize.html.haml`
- E-02: `app/controllers/oauth/device_authorizations_controller.rb`
- E-03: `config/routes.rb`
- E-04: `config/initializers/doorkeeper.rb`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面は「Authorize device to access...」と表示 | E-01 (行4) | ○ |
| C-02 | 説明文「Please make sure...」が表示される | E-01 (行6) | ○ |
| C-03 | ユーザーアバターが表示される | E-01 (行8) | ○ |
| C-04 | アバターサイズは24px | E-01 (行8: size: 24) | ○ |
| C-05 | ユーザー名が太字で表示される | E-01 (行10) | ○ |
| C-06 | ユーザー参照（@username）が表示される | E-01 (行13) | ○ |
| C-07 | 管理者には警告が表示される | E-01 (行14-17) | ○ |
| C-08 | current_user.admin?で管理者判定 | E-01 (行14) | ○ |
| C-09 | AlertComponentが使用される | E-01 (行15) | ○ |
| C-10 | variant: :warningで警告表示 | E-01 (行15) | ○ |
| C-11 | スコープが存在すれば表示 | E-01 (行19-22) | ○ |
| C-12 | @scopesにスコープ情報が格納 | E-02 (行20) | ○ |
| C-13 | hidden fieldでuser_codeを送信 | E-01 (行27) | ○ |
| C-14 | Confirmボタンがある | E-01 (行29-32) | ○ |
| C-15 | ButtonComponentが使用される | E-01 (行29) | ○ |
| C-16 | variant: :confirmでボタン表示 | E-01 (行30) | ○ |
| C-17 | POSTでauthorizeアクションに送信 | E-01 (行24) | ○ |
| C-18 | confirmアクションでスコープ取得 | E-02 (行16-27) | ○ |
| C-19 | device_grant_model.find_byでグラント検索 | E-02 (行18) | ○ |
| C-20 | layoutは'minimal' | E-02 (行5) | ○ |
| C-21 | use_doorkeeper_device_authorization_grantでルーティング | E-03 (行65-67) | ○ |
| C-22 | indexアクションでコード入力画面表示 | E-02 (行7-14) | ○ |
| C-23 | 関連機能No.88はOAuth2プロバイダ | E-06 | ○ |
| C-24 | AvatarComponentが使用される | E-01 (行8) | ○ |
| C-25 | デバイスグラントテーブル構造 | **根拠なし** | △ |
| C-26 | ポーリングでトークン取得 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25: oauth_device_grantsテーブルの詳細構造
  - 候補：Doorkeeper gem マイグレーション / データベーススキーマ / Doorkeeper ドキュメント
- C-26: デバイス側のポーリング処理の詳細
  - 候補：RFC 8628 / Doorkeeper gem実装 / トークンエンドポイント実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI構造はソースコードで確認済み
- 1: 中リスク - デバイスフローの完全な理解にはDoorkeeper gem内部確認が必要
- 1: 中リスク - 管理者権限でのデバイス認可のセキュリティ影響

## 6) レビュアーチェックリスト（最小）
- [ ] デバイスグラントの有効期限設定の確認
- [ ] ユーザーコードの形式・生成ルールの確認
- [ ] 管理者がデバイス認可した場合の権限範囲確認
- [ ] デバイスポーリング時のレート制限確認
- [ ] 期限切れ・無効コードのエラーハンドリング確認
