---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-Blame表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。低リスク。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/projects/blame/show.html.haml` - Blameビュー
- E-02: `app/controllers/projects/blame_controller.rb` - Blameコントローラー
- E-03: `config/routes/repository.rb` - ルーティング定義
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名「Blame表示」 | E-04 | ○ |
| C-02 | テンプレートパス `app/views/projects/blame/show.html.haml` | E-01 | ○ |
| C-03 | GET URL `/blame/*id` | E-03 (90行目) | ○ |
| C-04 | streaming URL `/blame/*id/streaming` | E-03 (89行目) | ○ |
| C-05 | blame_page URL `/blame_page/*id` | E-03 (88行目) | ○ |
| C-06 | showアクションの存在 | E-02 (17-25行目) | ○ |
| C-07 | load_blobメソッド | E-02 (40-47行目) | ○ |
| C-08 | require_non_binary_blobメソッド | E-02 (49-53行目) | ○ |
| C-09 | バイナリファイル時のリダイレクト | E-02 (52-53行目) | ○ |
| C-10 | "Blame for binary files is not supported."メッセージ | E-02 (53行目) | ○ |
| C-11 | load_blameメソッド | E-02 (66-81行目) | ○ |
| C-12 | BlameMode使用 | E-02 (67行目) | ○ |
| C-13 | BlamePagination使用 | E-02 (68行目) | ○ |
| C-14 | Gitlab::Blame使用 | E-02 (70-73行目) | ○ |
| C-15 | ignore_revs対応 | E-02 (72行目, 83-85行目) | ○ |
| C-16 | IgnoreRevsFormatError例外 | E-02 (22行目) | ○ |
| C-17 | IgnoreRevsFileError例外 | E-02 (24行目) | ○ |
| C-18 | ストリーミングモード | E-01 (6-14行目, 46-47行目) | ○ |
| C-19 | 色分け凡例（legend-box-0〜9） | E-01 (27-37行目) | ○ |
| C-20 | Show full blameボタン | E-01 (51行目) | ○ |
| C-21 | ページネーション | E-01 (61-62行目) | ○ |
| C-22 | 主機能：Blame表示(23) | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - ルーティングは3パターン全て確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ストリーミングモードの切り替え条件を確認
- [ ] 色分けロジックの詳細を確認（必要に応じて）
- [ ] .git-blame-ignore-revs機能の実際の動作を確認
- [ ] パフォーマンス（大きなファイル）を確認
