---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-ブランチ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。低リスク。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/projects/branches/index.html.haml` - ブランチ一覧ビュー
- E-02: `app/controllers/projects/branches_controller.rb` - ブランチコントローラー
- E-03: `config/routes/repository.rb` - ルーティング定義
- E-04: `app/services/branches/create_service.rb` - ブランチ作成サービス
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名「ブランチ一覧」 | E-05 | ○ |
| C-02 | テンプレートパス `app/views/projects/branches/index.html.haml` | E-01 | ○ |
| C-03 | GET URL `/branches` | E-03 (58行目) | ○ |
| C-04 | GET URL `/branches/:state` | E-03 (57行目) | ○ |
| C-05 | state制約（active/stale/all） | E-03 (57行目) | ○ |
| C-06 | indexアクションの存在 | E-02 (19-53行目) | ○ |
| C-07 | HTML/JSONレスポンス対応 | E-02 (20-53行目) | ○ |
| C-08 | モード取得（fetch_mode） | E-02 (243-248行目) | ○ |
| C-09 | overview_max_branches = 5 | E-02 (26行目) | ○ |
| C-10 | fetch_branches_by_mode | E-02 (213-217行目) | ○ |
| C-11 | fetch_branches_for_overview | E-02 (229-240行目) | ○ |
| C-12 | merged_branch_names取得 | E-02 (36行目) | ○ |
| C-13 | branch_pipeline_statuses取得 | E-02 (37-38行目) | ○ |
| C-14 | createアクション | E-02 (76-119行目) | ○ |
| C-15 | destroyアクション | E-02 (122-136行目) | ○ |
| C-16 | destroy_all_merged | E-02 (138-144行目) | ○ |
| C-17 | diverging_commit_counts | E-02 (56-73行目) | ○ |
| C-18 | タブナビゲーション | E-01 (14-18行目) | ○ |
| C-19 | View branch rulesボタン | E-01 (21-23行目) | ○ |
| C-20 | New branchボタン | E-01 (25-27行目) | ○ |
| C-21 | Delete merged branchesボタン | E-01 (28-31行目) | ○ |
| C-22 | ソートドロップダウン | E-01 (32-38行目) | ○ |
| C-23 | ページネーション | E-01 (58-61行目) | ○ |
| C-24 | Gitaly unavailableエラー処理 | E-01 (47-48行目), E-02 (44-46行目) | ○ |
| C-25 | 主機能：ブランチ管理(19) | E-06 | ○ |
| C-26 | 補助機能：保護ブランチ(25) | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - 4つの表示モードすべて確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 各モード（overview/active/stale/all）の表示内容を確認
- [ ] マージ済みブランチ一括削除の権限チェックを確認
- [ ] 保護ブランチ削除の制限を確認
- [ ] Keyset paginationの動作を確認
