---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-ブランチ新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。低リスク。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/projects/branches/new.html.haml` - ブランチ新規作成ビュー
- E-02: `app/controllers/projects/branches_controller.rb` - ブランチコントローラー
- E-03: `config/routes/repository.rb` - ルーティング定義
- E-04: `app/services/branches/create_service.rb` - ブランチ作成サービス
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名「ブランチ新規作成」 | E-05 | ○ |
| C-02 | テンプレートパス `app/views/projects/branches/new.html.haml` | E-01 | ○ |
| C-03 | resources :branches, only: [:new, :create] | E-03 (58行目) | ○ |
| C-04 | createアクションの存在 | E-02 (76-119行目) | ○ |
| C-05 | ブランチ名サニタイズ（strip_tags/sanitize） | E-02 (77行目) | ○ |
| C-06 | URIデコード（Addressable::URI.unescape） | E-02 (78行目) | ○ |
| C-07 | Branches::CreateService使用 | E-02 (82-83行目) | ○ |
| C-08 | Issue連携時のシステムノート | E-02 (87-93行目) | ○ |
| C-09 | 成功時のリダイレクト先 | E-02 (98-104行目) | ○ |
| C-10 | エラー時のrender action: 'new' | E-02 (106-107行目) | ○ |
| C-11 | "Ref is missing"エラー | E-04 (107行目) | ○ |
| C-12 | file directory conflictエラー | E-04 (90行目) | ○ |
| C-13 | invalid reference nameエラー | E-04 (92行目) | ○ |
| C-14 | validate_refメソッド | E-04 (106-110行目) | ○ |
| C-15 | create_default_branch | E-04 (112-120行目) | ○ |
| C-16 | branch_validation_service | E-04 (122-124行目) | ○ |
| C-17 | エラーメッセージ表示 | E-01 (5-8行目) | ○ |
| C-18 | form_tag送信先 | E-01 (11行目) | ○ |
| C-19 | ブランチ名入力欄 | E-01 (12-15行目) | ○ |
| C-20 | 作成元セレクター | E-01 (17-18行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - サービス層の処理フローは明確

## 6) レビュアーチェックリスト（最小）
- [ ] ブランチ名バリデーションの詳細ルールを確認
- [ ] Issue連携時のシステムノート内容を確認
- [ ] 空リポジトリ時のデフォルトブランチ作成処理を確認
- [ ] autodeployリダイレクトの条件を確認
