---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-タグ新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。低リスク。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/projects/tags/new.html.haml` - タグ新規作成ビュー
- E-02: `app/controllers/projects/tags_controller.rb` - タグコントローラー
- E-03: `config/routes/repository.rb` - ルーティング定義
- E-04: `app/services/tags/create_service.rb` - タグ作成サービス
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名「タグ新規作成」 | E-05 | ○ |
| C-02 | テンプレートパス `app/views/projects/tags/new.html.haml` | E-01 | ○ |
| C-03 | resources :tags, only: [:index, :show, :new, :create, :destroy] | E-03 (63行目) | ○ |
| C-04 | createアクションの存在 | E-02 (63-94行目) | ○ |
| C-05 | authorize_admin_tag! | E-02 (11行目) | ○ |
| C-06 | Tags::CreateService使用 | E-02 (67-68行目) | ○ |
| C-07 | target空チェック | E-04 (6行目) | ○ |
| C-08 | Gitlab::GitRefValidator.validate | E-04 (8-9行目) | ○ |
| C-09 | repository.add_tag呼び出し | E-04 (17行目) | ○ |
| C-10 | TagExistsErrorハンドリング | E-04 (18-19行目) | ○ |
| C-11 | PreReceiveErrorハンドリング | E-04 (20-21行目) | ○ |
| C-12 | NoRepositoryハンドリング | E-04 (22-23行目) | ○ |
| C-13 | expire_tags_cache | E-04 (27行目) | ○ |
| C-14 | タグ名入力欄（required: true） | E-01 (19行目) | ○ |
| C-15 | 作成元セレクター（Vue.js） | E-01 (23行目) | ○ |
| C-16 | メッセージ入力欄 | E-01 (29行目) | ○ |
| C-17 | Create tagボタン | E-01 (34-35行目) | ○ |
| C-18 | Cancelボタン | E-01 (36-37行目) | ○ |
| C-19 | エラーメッセージ表示 | E-01 (7-10行目) | ○ |
| C-20 | リリース作成案内 | E-01 (4-5行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - サービス層の処理フローは明確

## 6) レビュアーチェックリスト（最小）
- [ ] タグ名バリデーションの詳細ルールを確認
- [ ] 注釈付きタグと軽量タグの違いを確認
- [ ] レガシーのリリース作成機能の扱いを確認
- [ ] pre-receiveフック失敗時のエラー表示を確認
