---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-タグ詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。低リスク。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/projects/tags/show.html.haml` - タグ詳細ビュー
- E-02: `app/controllers/projects/tags_controller.rb` - タグコントローラー
- E-03: `config/routes/repository.rb` - ルーティング定義
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名「タグ詳細」 | E-04 | ○ |
| C-02 | テンプレートパス `app/views/projects/tags/show.html.haml` | E-01 | ○ |
| C-03 | resources :tags, only: [:index, :show, :new, :create, :destroy] | E-03 (63行目) | ○ |
| C-04 | showアクションの存在 | E-02 (49-61行目) | ○ |
| C-05 | repository.find_tag | E-02 (50行目) | ○ |
| C-06 | render_404 unless @tag | E-02 (52行目) | ○ |
| C-07 | releases.find_by(tag: @tag.name) | E-02 (54行目) | ○ |
| C-08 | repository.commit(@tag.dereferenced_target) | E-02 (55行目) | ○ |
| C-09 | CommitStatusesFinder使用 | E-02 (57-59行目) | ○ |
| C-10 | タグ名表示 | E-01 (12-14行目) | ○ |
| C-11 | 保護タグバッジ | E-01 (15-16行目) | ○ |
| C-12 | タグ作成者表示（ユーザー） | E-01 (18-25行目) | ○ |
| C-13 | タグ作成者表示（メールのみ） | E-01 (27-33行目) | ○ |
| C-14 | コミット情報表示 | E-01 (35-38行目) | ○ |
| C-15 | リリースリンク表示 | E-01 (40-41行目) | ○ |
| C-16 | 署名情報表示 | E-01 (44-47行目) | ○ |
| C-17 | パイプラインステータス表示 | E-01 (49-51行目) | ○ |
| C-18 | Browse filesボタン | E-01 (55行目) | ○ |
| C-19 | Browse commitsボタン | E-01 (56行目) | ○ |
| C-20 | ダウンロードボタン | E-01 (57行目) | ○ |
| C-21 | 削除ボタン（権限チェック付き） | E-01 (58-59行目) | ○ |
| C-22 | タグメッセージ表示 | E-01 (61-63行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - コントローラーの処理フローは明確

## 6) レビュアーチェックリスト（最小）
- [ ] タグ作成者のユーザー検索ロジックを確認
- [ ] 署名情報の表示内容を確認
- [ ] 保護タグ判定の条件を確認
- [ ] タグ削除後のリダイレクト先を確認
