---
generated_at: 2026-01-22 11:30:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：4-ユーザー登録画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **レート制限の具体的な設定値**：設定ファイルでの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/devise/registrations/new.html.haml` - ユーザー登録画面ビューテンプレート
- E-02: `app/views/devise/registrations/_signup_box_form.html.haml` - 登録フォームパーシャル
- E-03: `app/controllers/registrations_controller.rb` - 登録コントローラー（1-393行目）
- E-04: `app/models/user.rb` - ユーザーモデル（1-150行目確認）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（9-10行目）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（5行目）
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図（72-73行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/users/sign_up` でユーザー登録画面にアクセス | E-03 (Devise::RegistrationsController継承) | ○ |
| C-02 | 姓名の入力が必須 | E-02 (22-42行目 required: true) | ○ |
| C-03 | ユーザー名の入力が必須 | E-02 (43-56行目 required: true) | ○ |
| C-04 | ユーザー名の利用可能性がリアルタイムチェックされる | E-02 (46-47行目 js-validate-username) | ○ |
| C-05 | メールアドレスの入力が必須（招待以外） | E-02 (57-70行目 required: true) | ○ |
| C-06 | 招待時はメールアドレスが固定表示される | E-02 (12-18行目 @invite_email) | ○ |
| C-07 | パスワードの入力が必須 | E-02 (71-73行目) | ○ |
| C-08 | reCAPTCHAが設定時に表示される | E-02 (77-81行目), E-03 (240-252行目) | ○ |
| C-09 | Invisible Captchaが設定時に動作する | E-02 (10-11行目), E-03 (7行目 InvisibleCaptchaOnSignup) | ○ |
| C-10 | 利用規約同意文言が表示される | E-02 (84行目 _terms_of_service_notice) | ○ |
| C-11 | OAuthボタンが設定時に表示される | E-01 (17-27行目) | ○ |
| C-12 | Sign inリンクが表示される | E-01 (29-31行目) | ○ |
| C-13 | 姓名が空白の場合はエラーになる | E-03 (254-263行目) | ○ |
| C-14 | サインアップ無効時はアクセス不可 | E-03 (378-383行目) | ○ |
| C-15 | 管理者承認が必要な場合は承認待ち状態で作成 | E-03 (313-321行目, 266-270行目) | ○ |
| C-16 | 招待経由の場合は確認メールがスキップされる場合がある | E-03 (297-305行目) | ○ |
| C-17 | システムフックが実行される | E-03 (115-117行目) | ○ |
| C-18 | 利用規約同意が記録される | E-03 (79-84行目) | ○ |
| C-19 | 関連機能No.76,137が正しくマッピングされている | E-05 (9-10行目) | ○ |
| C-20 | 画面遷移（メール確認画面への遷移）が正しい | E-07 (72-73行目) | ○ |
| C-21 | POST /users でユーザー登録処理が実行される | E-03 (40行目) | ○ |
| C-22 | 絵文字ブロックが姓名フィールドに適用される | E-02 (24行目, 35行目 js-block-emoji) | ○ |
| C-23 | MAX_NAME_LENGTHは127文字 | E-04 (62行目) | ○ |
| C-24 | レート制限が適用される | E-03 (25-26行目 check_rate_limit!) | ○ |

## 4) 不足情報（Unknown / Missing）
- **レート制限の具体的な設定値**：`check_rate_limit!(:user_sign_up, scope: request.ip)` の閾値は設定ファイルで定義されているが、本レビュー時に未確認
  - 候補：`config/gitlab.yml` / 環境変数 / Gitlab::CurrentSettings

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分の主張がソースコードで裏付けられている
- **1（中リスク）**: レート制限設定は環境により異なる可能性があるため、デプロイ環境での確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] レート制限の設定値を確認
- [ ] reCAPTCHA設定の有効化状況を確認
- [ ] 管理者承認設定の状況を確認
- [ ] OAuthプロバイダーの設定状況を確認
- [ ] 利用規約の設定状況を確認
