---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-コミット一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。低リスク。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/projects/commits/show.html.haml` - コミット一覧ビュー
- E-02: `app/controllers/projects/commits_controller.rb` - コミットコントローラー
- E-03: `config/routes/repository.rb` - ルーティング定義
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名「コミット一覧」 | E-04 | ○ |
| C-02 | テンプレートパス `app/views/projects/commits/show.html.haml` | E-01 | ○ |
| C-03 | COMMITS_DEFAULT_LIMIT = 40 | E-02 (11行目) | ○ |
| C-04 | showアクションの存在 | E-02 (31-49行目) | ○ |
| C-05 | authenticate_sessionless_user!(:rss) | E-02 (12行目) | ○ |
| C-06 | assign_ref_vars | E-02 (16行目) | ○ |
| C-07 | validate_ref! | E-02 (18行目) | ○ |
| C-08 | validate_path | E-02 (19行目) | ○ |
| C-09 | set_commits | E-02 (21行目) | ○ |
| C-10 | HTML/ATOM/JSONレスポンス対応 | E-02 (37-48行目) | ○ |
| C-11 | MergeRequestsFinder使用 | E-02 (32-33行目) | ○ |
| C-12 | repository.find_commits_by_message | E-02 (102行目) | ○ |
| C-13 | repository.commits | E-02 (113行目) | ○ |
| C-14 | commits.load_tags | E-02 (116行目) | ○ |
| C-15 | commits.lazy_author | E-02 (117行目) | ○ |
| C-16 | commits.with_latest_pipeline | E-02 (119行目) | ○ |
| C-17 | permitted_params（limit, offset, search, author, committed_before, committed_after） | E-02 (124行目) | ○ |
| C-18 | Feature Flag: project_commits_refactor | E-01 (7, 13行目) | ○ |
| C-19 | 参照セレクター（Vue.js） | E-01 (22行目) | ○ |
| C-20 | パンくずナビ | E-01 (24-25行目) | ○ |
| C-21 | 作成者フィルター | E-01 (26行目) | ○ |
| C-22 | Browse filesボタン | E-01 (29行目) | ○ |
| C-23 | MRリンク/作成ボタン | E-01 (30-36行目) | ○ |
| C-24 | 検索フォーム | E-01 (39-40行目) | ○ |
| C-25 | RSSボタン | E-01 (42行目) | ○ |
| C-26 | 無限スクロールコンテナ | E-01 (47-52行目) | ○ |
| C-27 | 曖昧参照モーダル | E-01 (55行目) | ○ |
| C-28 | RSSフィード自動検出 | E-01 (10-11行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - コントローラーの処理フローは明確

## 6) レビュアーチェックリスト（最小）
- [ ] 無限スクロールのパフォーマンスを確認
- [ ] 日付フィルターの形式を確認
- [ ] 曖昧参照の判定ロジックを確認
- [ ] Feature Flag（project_commits_refactor）の影響範囲を確認
