---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：41-コミット詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **MSG-003のメッセージ内容**：コード内での正確な文言要確認
  2. **GPG署名の検証状態表示**：実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/commit_controller.rb`
- E-02: `app/views/projects/commit/show.html.haml`
- E-03: `app/views/projects/commit/_commit_box.html.haml`
- E-04: `app/models/commit.rb`
- E-05: `config/routes/repository.rb`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コミット詳細画面はリポジトリ内の個別コミットの詳細情報を表示する | E-01 (行6, 34-63), E-02 | ○ |
| C-02 | URLパターンは `/:namespace/:project/-/commit/:id` | E-05 (行110) | ○ |
| C-03 | `read_code`権限が必要 | E-01 (行17) | ○ |
| C-04 | Revert操作には`edit_tree`権限が必要 | E-01 (行25) | ○ |
| C-05 | パイプライン情報閲覧には`read_pipeline`権限が必要 | E-01 (行18) | ○ |
| C-06 | 差分表示は1ページ20ファイル | E-01 (行29: COMMIT_DIFFS_PER_PAGE = 20) | ○ |
| C-07 | コミットSHA、作成者、日時を表示 | E-03 (行8-21) | ○ |
| C-08 | 親コミット情報を表示 | E-03 (行37-39) | ○ |
| C-09 | 関連ブランチ・タグを表示 | E-03 (行40-46) | ○ |
| C-10 | パイプライン状態を表示 | E-03 (行54-58), E-01 (行336-344) | ○ |
| C-11 | マージリクエスト情報を表示 | E-03 (行48-52), E-01 (行131-145) | ○ |
| C-12 | `Commits::RevertService`を使用してRevert実行 | E-01 (行157-162) | ○ |
| C-13 | `Commits::CherryPickService`を使用してCherry-pick実行 | E-01 (行177-184) | ○ |
| C-14 | 差分表示切り替えはCookieに保存 | E-01 (行35: apply_diff_view_cookie!) | ○ |
| C-15 | コメント投稿はnotesテーブルにINSERT | E-01 (行302-333), E-04 | ○ |
| C-16 | Revert成功メッセージを表示 | E-01 (行159) | ○ |
| C-17 | Cherry-pick成功メッセージを表示 | E-01 (行179-180) | ○ |
| C-18 | コミットが存在しない場合404を返却 | E-01 (行296: git_not_found!) | ○ |
| C-19 | Rapid Diffs機能がフィーチャーフラグで制御される | E-01 (行39, 189-195) | ○ |
| C-20 | showアクションでHTML/diff/patchフォーマットに対応 | E-01 (行37-62) | ○ |
| C-21 | 署名情報が存在する場合表示される | E-03 (行5-6) | ○ |
| C-22 | コミッターが作成者と異なる場合、別途表示 | E-03 (行18-21) | ○ |
| C-23 | Browse filesボタンでファイルツリーに遷移 | E-03 (行23) | ○ |
| C-24 | 画面遷移図でコミット一覧からコミット詳細への遷移が定義 | E-08 | ○ |
| C-25 | 画面機能マッピングで機能21と22が関連付け | E-07 (行63-64) | ○ |
| C-26 | 画面No.41として画面一覧に登録されている | E-06 (行42) | ○ |
| C-27 | GPG署名の検証状態表示 | **部分的確認** | △ |
| C-28 | Revertコンフリクト時のエラーメッセージ | **コード内文言要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- GPG署名検証の詳細実装（`_signature`パーシャルの詳細）
  - 候補：`app/views/projects/commit/_signature.html.haml` / `app/models/commit_signature.rb`
- Revert失敗時の正確なエラーメッセージ文言
  - 候補：`app/services/commits/revert_service.rb` / `config/locales/en.yml`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URL/ルーティング、権限チェック（コードで明確に確認可能）
- 0: 低リスク - 差分表示のページネーション設定（定数で定義）
- 1: 中リスク - メッセージ仕様（i18nファイルとの照合が必要）
- 0: 低リスク - データベース更新仕様（notesテーブルへの書き込みは標準的）

## 6) レビュアーチェックリスト（最小）
- [ ] `app/services/commits/revert_service.rb`でエラーメッセージを確認
- [ ] GPG署名表示のパーシャル実装を確認
- [ ] i18nファイルでメッセージ文言を照合
- [ ] 実際の画面でRevert/Cherry-pick操作を確認
