---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：42-比較画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **フォークプロジェクト選択時の動作**：Vue コンポーネント実装の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/compare_controller.rb`
- E-02: `app/views/projects/compare/index.html.haml`
- E-03: `config/routes/repository.rb`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 比較画面は2つのリビジョン間の比較対象を選択する画面 | E-01, E-02 | ○ |
| C-02 | URLは`/:namespace/:project/-/compare` | E-03 (行12) | ○ |
| C-03 | `read_code`権限が必要 | E-01 (行15) | ○ |
| C-04 | from/to/from_project_idパラメータを受け付ける | E-01 (行211-222) | ○ |
| C-05 | straightパラメータで2ドット比較を指定可能 | E-01 (行69-70, 148-149) | ○ |
| C-06 | from/to未入力時にエラーメッセージを表示 | E-01 (行65-68) | ○ |
| C-07 | 不正なブランチ名でエラーメッセージを表示 | E-01 (行105-111) | ○ |
| C-08 | JavaScriptコンポーネント`#js-compare-selector`を使用 | E-02 (行5) | ○ |
| C-09 | `CompareService`を使用して比較を実行 | E-01 (行145) | ○ |
| C-10 | 3ドット比較がデフォルト | E-01 (行69-70) | ○ |
| C-11 | target_projects JSONエンドポイントが存在 | E-03 (行21-23), E-01 (行91-93) | ○ |
| C-12 | フォークプロジェクトの選択が可能 | E-01 (行115-130) | ○ |
| C-13 | 既存MRが存在する場合にリンクを表示 | E-01 (行204-208) | ○ |
| C-14 | createアクションで比較結果画面へリダイレクト | E-01 (行62-74) | ○ |
| C-15 | バリデーションでリダイレクト | E-01 (行105-111) | ○ |
| C-16 | 画面No.42として画面一覧に登録 | E-04 (行43) | ○ |
| C-17 | 機能No.22と関連付け | E-05 (行65) | ○ |
| C-18 | フォークプロジェクト選択時のブランチ取得動作 | **Vue実装要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- フロントエンドVueコンポーネントの詳細実装
  - 候補：`app/assets/javascripts/projects/compare/` ディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URL/ルーティング（コードで明確に確認可能）
- 0: 低リスク - 権限チェック（before_actionで定義）
- 0: 低リスク - パラメータ処理（permit で明確に定義）
- 1: 中リスク - フロントエンドの動的挙動（Vue実装の確認が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] `app/assets/javascripts/projects/compare/`のVueコンポーネントを確認
- [ ] フォークプロジェクト選択時のAPI呼び出しを確認
- [ ] 3ドット/2ドット比較の差異を画面で確認
