---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：44-ネットワークグラフ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **JavaScriptグラフ描画実装**：フロントエンド実装の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/network_controller.rb`
- E-02: `app/views/projects/network/show.html.haml`
- E-03: `config/routes/repository.rb`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ネットワークグラフ画面はブランチとコミットの関係を表示する | E-01, E-02 | ○ |
| C-02 | URLは`/:namespace/:project/-/network/:id` | E-03 (行46) | ○ |
| C-03 | `read_code`権限が必要 | E-01 (行9) | ○ |
| C-04 | filter_ref, extended_sha1パラメータを受け付ける | E-01 (行40) | ○ |
| C-05 | ページタイトルは"Repository graph" | E-02 (行1) | ○ |
| C-06 | 矢印キーでナビゲーション可能 | E-02 (行8) | ○ |
| C-07 | tabindex="0"でフォーカス可能 | E-02 (行18) | ○ |
| C-08 | コミットURLはテンプレート形式 | E-01 (行22) | ○ |
| C-09 | JSONレスポンスでグラフデータを返却 | E-01 (行31-33) | ○ |
| C-10 | Network::Graphでグラフ生成 | E-01 (行32) | ○ |
| C-11 | 未ログインで非デフォルトブランチアクセス時に認証要求 | E-01 (行16-17, 51-54) | ○ |
| C-12 | extended_sha1でコミット検索 | E-01 (行43-47, 26-28) | ○ |
| C-13 | コミットが見つからない場合フラッシュ表示 | E-01 (行26-28) | ○ |
| C-14 | 画面No.44として画面一覧に登録 | E-04 (行45) | ○ |
| C-15 | 機能No.24と関連付け | E-05 (行67) | ○ |
| C-16 | #js-graph-ref-switcherでブランチ切り替え | E-02 (行13) | ○ |
| C-17 | #js-ref-search-formでコミット検索 | E-02 (行15) | ○ |
| C-18 | JavaScriptでのグラフ描画実装 | **詳細確認必要** | △ |

## 4) 不足情報（Unknown / Missing）
- JavaScriptグラフ描画の詳細実装
  - 候補：`app/assets/javascripts/network/` ディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URL/ルーティング（コードで明確に確認可能）
- 0: 低リスク - 権限チェック（before_actionで定義）
- 0: 低リスク - パラメータ処理（permitで明確に定義）
- 1: 中リスク - フロントエンドのグラフ描画実装

## 6) レビュアーチェックリスト（最小）
- [ ] `app/assets/javascripts/network/`のJavaScript実装を確認
- [ ] `lib/network/graph.rb`のグラフデータ構造を確認
- [ ] 実際の画面で矢印キーナビゲーションを確認
- [ ] フィーチャーフラグ`require_login_for_commit_tree`の動作を確認
