---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：45-貢献者グラフ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **フロントエンドグラフ描画実装**：Vueコンポーネントの詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/graphs_controller.rb`
- E-02: `app/views/projects/graphs/show.html.haml`
- E-03: `config/routes/repository.rb`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 貢献者グラフ画面はリポジトリへの貢献者統計を表示する | E-01, E-02 | ○ |
| C-02 | URLは`/:namespace/:project/-/graphs/:id` | E-03 (行48) | ○ |
| C-03 | `read_repository_graphs`権限が必要 | E-01 (行10) | ○ |
| C-04 | ページタイトルは"Contributor analytics" | E-02 (行1), E-01 (行1) | ○ |
| C-05 | 最大6000件のコミットを取得 | E-01 (行24) | ○ |
| C-06 | マージコミットは除外される | E-01 (行32) | ○ |
| C-07 | JSONレスポンスでコミットログを返却 | E-01 (行31-41) | ○ |
| C-08 | author_name, author_email, dateを返却 | E-01 (行34-38) | ○ |
| C-09 | 使用量追跡が有効（track_event） | E-01 (行12-16) | ○ |
| C-10 | #js-contributors-graphでグラフを描画 | E-02 (行7) | ○ |
| C-11 | charts, commits, languages, ciエンドポイントが存在 | E-03 (行48-54) | ○ |
| C-12 | chartsアクションで各種グラフを取得 | E-01 (行54-58) | ○ |
| C-13 | commits, languagesはchartsにリダイレクト | E-01 (行46-51) | ○ |
| C-14 | 画面No.45として画面一覧に登録 | E-04 (行46) | ○ |
| C-15 | 機能No.125と関連付け | E-05 (行68) | ○ |
| C-16 | Vueコンポーネントの詳細実装 | **詳細確認必要** | △ |

## 4) 不足情報（Unknown / Missing）
- フロントエンドVueコンポーネントの詳細実装
  - 候補：`app/assets/javascripts/pages/projects/graphs/show/` ディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URL/ルーティング（コードで明確に確認可能）
- 0: 低リスク - 権限チェック（before_actionで定義）
- 0: 低リスク - JSONレスポンスフォーマット（コードで明確）
- 1: 中リスク - フロントエンドのグラフ描画実装

## 6) レビュアーチェックリスト（最小）
- [ ] `app/assets/javascripts/pages/projects/graphs/show/`のVueコンポーネントを確認
- [ ] `lib/gitlab/graphs/commits.rb`の統計処理を確認
- [ ] 実際の画面でグラフ表示を確認
- [ ] 使用量追跡（Snowplow）の動作を確認
