---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：46-ファイル検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **JavaScriptファジー検索実装**：フロントエンド実装の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/find_file_controller.rb`
- E-02: `app/views/projects/find_file/show.html.haml`
- E-03: `config/routes/repository.rb`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ファイル検索画面はリポジトリ内のファイルをパス名で検索する | E-01, E-02 | ○ |
| C-02 | URLは`/:namespace/:project/-/find_file/:id` | E-03 (行104) | ○ |
| C-03 | `read_code`権限が必要 | E-01 (行11) | ○ |
| C-04 | showアクションでHTML表示 | E-01 (行16-23) | ○ |
| C-05 | listアクションでJSON応答 | E-01 (行26-31) | ○ |
| C-06 | `@repo.ls_files(@commit.id)`でファイル一覧取得 | E-01 (行27) | ○ |
| C-07 | コミットが存在しない場合404を返却 | E-01 (行17) | ○ |
| C-08 | プレースホルダーは"Find by path" | E-02 (行16) | ○ |
| C-09 | 空状態メッセージ"There are no matching files" | E-02 (行27) | ○ |
| C-10 | js-file-finderクラスで初期化 | E-02 (行7) | ○ |
| C-11 | file_find_url, find_tree_url, blob_url_templateをデータ属性で渡す | E-02 (行7) | ○ |
| C-12 | #js-blob-ref-switcherでブランチ切り替え | E-02 (行10) | ○ |
| C-13 | 画面No.46として画面一覧に登録 | E-04 (行47) | ○ |
| C-14 | 機能No.103と関連付け | E-05 (行69) | ○ |
| C-15 | filesエンドポイントが存在 | E-03 (行105) | ○ |
| C-16 | JavaScriptファジー検索の実装詳細 | **詳細確認必要** | △ |

## 4) 不足情報（Unknown / Missing）
- JavaScriptのファジー検索アルゴリズム実装
  - 候補：`app/assets/javascripts/` 内のfile finder関連ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URL/ルーティング（コードで明確に確認可能）
- 0: 低リスク - 権限チェック（before_actionで定義）
- 0: 低リスク - JSONレスポンス（ls_filesで単純配列）
- 1: 中リスク - フロントエンドのファジー検索実装

## 6) レビュアーチェックリスト（最小）
- [ ] JavaScriptのfile finderコンポーネントを確認
- [ ] ファジー検索アルゴリズムを確認
- [ ] 実際の画面で検索動作を確認
- [ ] キーボードショートカット「t」の動作を確認
