---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：47-課題一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **Work Items Vueコンポーネントの詳細**：フロントエンド実装の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/issues_controller.rb`
- E-02: `app/views/projects/issues/index.html.haml`
- E-03: `config/routes/issues.rb`
- E-04: `app/models/issue.rb`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 課題一覧画面はプロジェクトの課題を一覧表示する | E-01, E-02 | ○ |
| C-02 | URLは`/:namespace/:project/-/issues` | E-03 (行5) | ○ |
| C-03 | `check_issues_available!`で課題機能を確認 | E-01 (行29) | ○ |
| C-04 | ATOMフィードに対応 | E-01 (行100) | ○ |
| C-05 | iCalendarフィードに対応（calendar） | E-03 (行3), E-01 (行104-106) | ○ |
| C-06 | bulk_updateエンドポイントが存在 | E-03 (行24) | ○ |
| C-07 | import_csvエンドポイントが存在 | E-03 (行25) | ○ |
| C-08 | export_csvエンドポイントが存在 | E-03 (行26) | ○ |
| C-09 | service_deskエンドポイントが存在 | E-03 (行23) | ○ |
| C-10 | IssuableExportCsvWorkerでエクスポート | E-01 (行272-278) | ○ |
| C-11 | エクスポート完了メールを送信 | E-01 (行276-277) | ○ |
| C-12 | Issues::PrepareImportCsvServiceでインポート | E-01 (行281-290) | ○ |
| C-13 | Work Items有効時にリダイレクト | E-01 (行494-497) | ○ |
| C-14 | IssuesFinder を使用 | E-01 (行405-407) | ○ |
| C-15 | TYPES_FOR_LISTで表示対象を制限 | E-04 (行51), E-01 (行455) | ○ |
| C-16 | 検索レート制限をチェック | E-01 (行36-38) | ○ |
| C-17 | Jiraインポート状態表示 | E-02 (行12-15) | ○ |
| C-18 | #js-work-itemsでVueコンポーネント表示 | E-02 (行17) | ○ |
| C-19 | 画面No.47として画面一覧に登録 | E-05 (行48) | ○ |
| C-20 | 機能No.36, 40, 41と関連付け | E-06 (行70-72) | ○ |
| C-21 | create_issue権限が必要（新規作成） | E-01 (行44) | ○ |
| C-22 | authorize_import_issues!でインポート権限チェック | E-01 (行52) | ○ |
| C-23 | set_issuables_indexで一覧データ取得 | E-01 (行33-35) | ○ |
| C-24 | Work Items Vueコンポーネントの詳細実装 | **詳細確認必要** | △ |

## 4) 不足情報（Unknown / Missing）
- Work Items Vueコンポーネントの詳細実装
  - 候補：`app/assets/javascripts/work_items/` ディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URL/ルーティング（コードで明確に確認可能）
- 0: 低リスク - 権限チェック（before_actionで定義）
- 0: 低リスク - CSVインポート/エクスポート処理
- 1: 中リスク - Work Items Vueコンポーネントの動作

## 6) レビュアーチェックリスト（最小）
- [ ] `app/assets/javascripts/work_items/`のVueコンポーネントを確認
- [ ] `app/finders/issues_finder.rb`の検索ロジックを確認
- [ ] Work Items機能が有効な場合のリダイレクト動作を確認
- [ ] CSVインポート/エクスポートの動作を確認
