---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：48-課題新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **テンプレート適用のフロントエンド実装**：詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/issues_controller.rb`
- E-02: `app/views/projects/issues/new.html.haml`
- E-03: `config/routes/issues.rb`
- E-04: `app/models/issue.rb`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 課題新規作成画面は新しい課題を作成する | E-01, E-02 | ○ |
| C-02 | URLは`/:namespace/:project/-/issues/new` | E-03 (行5) | ○ |
| C-03 | `authorize_create_issue!`で権限チェック | E-01 (行44) | ○ |
| C-04 | Issues::BuildServiceで初期化 | E-01 (行118) | ○ |
| C-05 | Issues::CreateServiceで課題作成 | E-01 (行174) | ○ |
| C-06 | 成功時に課題詳細へリダイレクト | E-01 (行193) | ○ |
| C-07 | スパムチェックでCAPTCHA表示 | E-01 (行196) | ○ |
| C-08 | merge_request_to_resolve_discussions_ofパラメータ対応 | E-01 (行113, 169) | ○ |
| C-09 | discussion_to_resolveパラメータ対応 | E-01 (行114, 171) | ○ |
| C-10 | ディスカッション解決成功メッセージ | E-01 (行186-190) | ○ |
| C-11 | add_related_issueパラメータ対応 | E-01 (行122, 168, 470-473) | ○ |
| C-12 | observability_linksパラメータ対応 | E-01 (行115, 170) | ○ |
| C-13 | issue_params_attributesでパラメータ定義 | E-01 (行364-378) | ○ |
| C-14 | 隠しパラメータとしてtitle/description等を設定 | E-02 (行10-20) | ○ |
| C-15 | #js-work-itemsでVueコンポーネント表示 | E-02 (行22) | ○ |
| C-16 | store_uriでリダイレクト先を保存 | E-01 (行23, 385-387) | ○ |
| C-17 | 認証必須（authenticate_user!） | E-01 (行22) | ○ |
| C-18 | 画面No.48として画面一覧に登録 | E-05 (行49) | ○ |
| C-19 | 機能No.36, 149と関連付け | E-06 (行73-74) | ○ |
| C-20 | MRディスカッション解決のカウント追跡 | E-01 (行127) | ○ |
| C-21 | confidentialパラメータ対応 | E-01 (行116) | ○ |
| C-22 | テンプレート適用のフロントエンド実装 | **詳細確認必要** | △ |

## 4) 不足情報（Unknown / Missing）
- イシューテンプレート選択のフロントエンド実装
  - 候補：`app/assets/javascripts/` 内のissue form関連ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URL/ルーティング（コードで明確に確認可能）
- 0: 低リスク - 権限チェック（before_actionで定義）
- 0: 低リスク - 課題作成サービス処理
- 1: 中リスク - テンプレート適用のフロントエンド動作

## 6) レビュアーチェックリスト（最小）
- [ ] `app/services/issues/build_service.rb`の初期化処理を確認
- [ ] `app/services/issues/create_service.rb`の作成処理を確認
- [ ] テンプレート機能のフロントエンド実装を確認
- [ ] MRディスカッション解決の動作を確認
