---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：49-課題詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **Vueコンポーネント（#js-issuable-app）の詳細実装**：フロントエンド確認が必要
  2. **リアルタイム更新の実装**：WebSocket/ポーリングの詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/issues_controller.rb`
- E-02: `app/views/projects/issues/show.html.haml`
- E-03: `app/views/projects/issues/_details_content.html.haml`
- E-04: `config/routes/issues.rb`
- E-05: `app/models/issue.rb`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 課題詳細画面は個別の課題の詳細情報を表示する | E-01, E-02 | ○ |
| C-02 | URLは`/:namespace/:project/-/issues/:id` | E-04 (行5) | ○ |
| C-03 | discussionsエンドポイントが存在 | E-04 (行15), E-01 (行297-301) | ○ |
| C-04 | realtime_changesエンドポイントが存在 | E-04 (行13) | ○ |
| C-05 | related_branchesエンドポイントが存在 | E-04 (行11) | ○ |
| C-06 | can_create_branchエンドポイントが存在 | E-04 (行12), E-01 (行246-256) | ○ |
| C-07 | toggle_subscriptionエンドポイントが存在 | E-04 (行7) | ○ |
| C-08 | toggle_award_emojiエンドポイントが存在 | E-04 (行5, Awardable concern) | ○ |
| C-09 | moveエンドポイントが存在 | E-04 (行9), E-01 (行200-220) | ○ |
| C-10 | reorderエンドポイントが存在 | E-04 (行10), E-01 (行222-229) | ○ |
| C-11 | designsエンドポイントが存在 | E-04 (行16), E-01 (行153) | ○ |
| C-12 | incident_tabパラメータ対応 | E-04 (行17-20), E-01 (行505-511) | ○ |
| C-13 | Work Item有効時にリダイレクト | E-01 (行483-492) | ○ |
| C-14 | redirect_if_work_itemで判定 | E-01 (行40) | ○ |
| C-15 | _details_contentパーシャルを使用 | E-02 (行21), E-03 | ○ |
| C-16 | #js-issuable-appでVueコンポーネント | E-03 (行8-9) | ○ |
| C-17 | 絵文字ブロック表示 | E-03 (行19) | ○ |
| C-18 | 関連課題表示 | E-03 (行26) | ○ |
| C-19 | 関連MR表示 | E-03 (行28-30) | ○ |
| C-20 | 関連ブランチ表示 | E-03 (行32-35) | ○ |
| C-21 | サイドバー表示 | E-03 (行44) | ○ |
| C-22 | 画面No.49として画面一覧に登録 | E-06 (行50) | ○ |
| C-23 | 機能No.37, 38, 42, 43と関連付け | E-07 (行75-78) | ○ |
| C-24 | inc_relations_for_viewで関連データ取得 | E-01 (行318) | ○ |
| C-25 | Vueコンポーネントの詳細実装 | **詳細確認必要** | △ |
| C-26 | リアルタイム更新の実装詳細 | **詳細確認必要** | △ |

## 4) 不足情報（Unknown / Missing）
- Vueコンポーネント（#js-issuable-app）の詳細実装
  - 候補：`app/assets/javascripts/issues/` ディレクトリ
- リアルタイム更新（WebSocket/ポーリング）の実装
  - 候補：`app/assets/javascripts/` 内のrealtime関連ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URL/ルーティング（コードで明確に確認可能）
- 0: 低リスク - 各種エンドポイントの存在
- 1: 中リスク - フロントエンドVueコンポーネントの詳細動作
- 1: 中リスク - リアルタイム更新の実装

## 6) レビュアーチェックリスト（最小）
- [ ] `app/assets/javascripts/issues/`のVueコンポーネントを確認
- [ ] realtime_changesの実装とポーリング間隔を確認
- [ ] Work Item機能有効時の動作を確認
- [ ] インシデントタブの表示条件を確認
