---
generated_at: 2026-01-22 11:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-アカウントロック解除画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/devise/unlocks/new.html.haml` - アカウントロック解除画面ビューテンプレート
- E-02: `app/models/user.rb` - ユーザーモデル（119行目 devise :lockable）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（11行目）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（6行目）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図（61-62行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/users/unlock/new` でロック解除画面にアクセス | E-01 (Devise convention) | ○ |
| C-02 | メールアドレス入力が必須 | E-01 (7行目) | ○ |
| C-03 | タイトルが「Resend unlock instructions」 | E-01 (1行目 _tab_single) | ○ |
| C-04 | Sign inリンクが表示される | E-01 (12行目 _sign_in_link) | ○ |
| C-05 | Deviseの:lockableモジュールにより実装 | E-02 (119行目) | ○ |
| C-06 | フォームバリデーションが実行される | E-01 (2行目 gl-show-field-errors) | ○ |
| C-07 | エラーメッセージ表示領域がある | E-01 (3-4行目 devise-errors) | ○ |
| C-08 | POST /users/unlock でメール送信が実行される | E-01 (2行目 unlock_path) | ○ |
| C-09 | 関連機能No.76が正しくマッピングされている | E-03 (11行目) | ○ |
| C-10 | 画面遷移（ログイン画面からの遷移）が正しい | E-05 (61-62行目) | ○ |
| C-11 | autocorrect属性がoffに設定される | E-01 (7行目) | ○ |
| C-12 | autocapitalize属性がoffに設定される | E-01 (7行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] Devise設定でロック解除トークンの有効期限を確認
- [ ] ロック閾値（失敗回数）の設定を確認
