---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：50-ボード一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **Vueコンポーネント（#js-issuable-board-app）の詳細実装**：フロントエンド確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/boards_controller.rb`
- E-02: `app/controllers/concerns/boards_actions.rb`
- E-03: `app/views/projects/boards/index.html.haml`
- E-04: `app/views/shared/boards/_show.html.haml`
- E-05: `config/routes/project.rb`
- E-06: `app/models/board.rb`
- E-07: `app/helpers/boards_helper.rb`
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ボード一覧画面は課題ボードを表示する | E-01, E-03 | ○ |
| C-02 | URLは`/:namespace/:project/-/boards` | E-05 (行242) | ○ |
| C-03 | `check_issues_available!`で課題機能を確認 | E-01 (行7) | ○ |
| C-04 | `authorize_read_board!`で権限チェック | E-01 (行32-34), E-02 (行8) | ○ |
| C-05 | `redirect_to_recent_board`でリダイレクト | E-02 (行9, 28-31) | ○ |
| C-06 | ボード未存在時に自動作成 | E-02 (行14-17) | ○ |
| C-07 | `Boards::BoardsFinder`でボード検索 | E-01 (行20-24), E-02 (行41-44) | ○ |
| C-08 | `Boards::CreateService`でボード作成 | E-01 (行26-30) | ○ |
| C-09 | `Boards::Visits::CreateService`で訪問履歴更新 | E-02 (行23, 46-48) | ○ |
| C-10 | `index.html.haml`が`_show`パーシャルを呼出 | E-03 (行1) | ○ |
| C-11 | `#js-issuable-board-app`でVueコンポーネント | E-04 (行22) | ○ |
| C-12 | `board_data`でVueにデータを渡す | E-04 (行22), E-07 (行8-30) | ○ |
| C-13 | エピックボードとの共通処理 | E-04 (行5-6) | ○ |
| C-14 | `can_update?`で更新権限を確認 | E-07 (行107-109) | ○ |
| C-15 | `can_admin_list?`でリスト管理権限を確認 | E-07 (行111-113) | ○ |
| C-16 | `can_admin_board?`でボード管理権限を確認 | E-07 (行115-117) | ○ |
| C-17 | `RECENT_BOARDS_SIZE = 4`で履歴数制限 | E-06 (行6) | ○ |
| C-18 | `multiple_issue_boards_available?`でライセンス確認 | E-02 (行29), E-07 (行90-92) | ○ |
| C-19 | `disabled_for?`でボード無効状態を判定 | E-06 (行56-60), E-07 (行11) | ○ |
| C-20 | 画面No.50として画面一覧に登録 | E-08 (行51) | ○ |
| C-21 | 機能No.39と関連付け | E-09 (行79) | ○ |
| C-22 | `work_item_tasks_on_boards`フラグ対応 | E-01 (行9-10) | ○ |
| C-23 | プロジェクトとグループ両方に対応 | E-06 (行8-9, 36-42), E-07 (行42-48) | ○ |
| C-24 | Vueコンポーネントの詳細実装 | **詳細確認必要** | △ |

## 4) 不足情報（Unknown / Missing）
- Vueコンポーネント（#js-issuable-board-app）の詳細実装
  - 候補：`app/assets/javascripts/boards/` ディレクトリ
- リスト（List）モデルの詳細
  - 候補：`app/models/list.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URL/ルーティング（コードで明確に確認可能）
- 0: 低リスク - 権限チェック（before_actionで定義）
- 0: 低リスク - ボード自動作成ロジック
- 1: 中リスク - フロントエンドVueコンポーネントの詳細動作

## 6) レビュアーチェックリスト（最小）
- [ ] `app/assets/javascripts/boards/`のVueコンポーネントを確認
- [ ] `app/models/list.rb`のリスト構造を確認
- [ ] `app/services/boards/`のサービス処理を確認
- [ ] 複数ボード機能のライセンス条件を確認
- [ ] ボード無効状態（`disabled_for?`）の動作を確認
