---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：51-ボード表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL API仕様詳細**：フロントエンドのAPI呼び出し詳細は要確認
  2. **Work Items統合計画**：将来の移行計画は公式ドキュメント要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/boards_controller.rb` (L1-38)
- E-02: `app/views/projects/boards/show.html.haml` (L1-2)
- E-03: `app/views/shared/boards/_show.html.haml` (L1-23)
- E-04: `app/models/board.rb` (L1-64)
- E-05: `app/helpers/boards_helper.rb` (L1-121)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (L80)
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` (L52)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BoardsControllerがshowアクションを提供 | E-01 | ○ |
| C-02 | BoardsActionsをincludeして共通ロジックを使用 | E-01 (L4-5) | ○ |
| C-03 | read_issue_board権限で閲覧可能 | E-01 (L32-34) | ○ |
| C-04 | show.html.hamlがshared/boards/showを呼び出し | E-02 | ○ |
| C-05 | Vue.jsアプリがjs-issuable-board-appにマウント | E-03 (L22) | ○ |
| C-06 | board_dataヘルパーでデータを提供 | E-03, E-05 | ○ |
| C-07 | BoardモデルがProjectまたはGroupに属する | E-04 (L8-9) | ○ |
| C-08 | Boardはlistsを複数持つ | E-04 (L11) | ○ |
| C-09 | disabled_for?メソッドで無効化チェック | E-04 (L56-60) | ○ |
| C-10 | can_update?でadmin_issue権限チェック | E-05 (L107-109) | ○ |
| C-11 | can_admin_list?でリスト管理権限チェック | E-05 (L111-113) | ○ |
| C-12 | can_admin_board?でボード管理権限チェック | E-05 (L115-117) | ○ |
| C-13 | 画面No.51がボード表示画面 | E-07 | ○ |
| C-14 | 機能No.39イシューボードが主機能 | E-06 | ○ |
| C-15 | フィルタリング機能がある | E-05 (L58-63) | ○ |
| C-16 | GraphQL APIで課題データを取得 | **コード未確認** | △ |
| C-17 | ドラッグ＆ドロップでラベル更新 | **フロントエンド未確認** | △ |
| C-18 | リスト追加・削除機能がある | E-04 (L11) | ○ |

## 4) 不足情報（Unknown / Missing）
- GraphQL APIのスキーマ定義とクエリ詳細
  - 候補：`app/graphql/types/board_type.rb` / `app/graphql/resolvers/` / GraphQL関連ドキュメント
- フロントエンドVue.jsコンポーネントの詳細
  - 候補：`app/assets/javascripts/boards/` / Vueコンポーネント群

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - フロントエンド実装詳細はバックエンドコードからは確認困難
- 0: 低リスク - バックエンド処理フローは明確に確認可能
- 0: 低リスク - 権限チェックロジックはコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] GraphQL APIのエンドポイントとスキーマを確認
- [ ] フロントエンドのドラッグ＆ドロップ実装を確認
- [ ] 複数ボード機能のライセンス条件を確認
- [ ] Work Items統合の影響範囲を確認
