---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：52-マイルストーン一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **マイルストーン昇格の詳細仕様**：昇格サービスの詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/milestones_controller.rb` (L1-201)
- E-02: `app/views/projects/milestones/index.html.haml` (L1-37)
- E-03: `app/models/milestone.rb` (L1-341)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (L81)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (L53)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | indexアクションがマイルストーン一覧を提供 | E-01 (L27-44) | ○ |
| C-02 | デフォルトソートはdue_date_asc | E-01 (L28) | ○ |
| C-03 | states_countで状態別件数を取得 | E-03 (L212-224), E-01 (L33) | ○ |
| C-04 | for_projectsスコープでプロジェクトマイルストーンをフィルタ | E-01 (L37), E-03 (L61) | ○ |
| C-05 | admin_milestone権限で作成・編集・削除が可能 | E-01 (L16-17, L174-176) | ○ |
| C-06 | admin_milestoneがプロジェクトグループにあれば昇格可能 | E-01 (L19-20, L178-180) | ○ |
| C-07 | 検索フォームがある | E-02 (L11) | ○ |
| C-08 | ソートドロップダウンがある | E-02 (L12) | ○ |
| C-09 | 新規作成ボタンが権限により表示制御 | E-02 (L13-15) | ○ |
| C-10 | ページネーションがある | E-02 (L31) | ○ |
| C-11 | 画面No.52がマイルストーン一覧 | E-05 | ○ |
| C-12 | 機能No.41マイルストーン管理が主機能 | E-04 | ○ |
| C-13 | Milestoneは状態遷移を持つ（active/closed） | E-03 (L93-105) | ○ |
| C-14 | sort_by_attributeで並び替え | E-03 (L177-197) | ○ |
| C-15 | グループマイルストーンへの昇格サービスが存在 | **Promote Service未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- マイルストーン昇格サービスの詳細実装
  - 候補：`app/services/milestones/promote_service.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な一覧表示機能は明確に確認可能
- 0: 低リスク - 権限チェックロジックはコードから確認済み
- 0: 低リスク - フィルタリング・ソートロジックも確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] マイルストーン削除時の関連データ処理を確認
- [ ] グループマイルストーン昇格の詳細フローを確認
- [ ] 状態遷移（active↔closed）の条件を確認
