---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：53-マイルストーン新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **CreateServiceの詳細実装**：サービスクラスの詳細確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/milestones_controller.rb` (L46-73, L182-192)
- E-02: `app/views/projects/milestones/new.html.haml` (L1-7)
- E-03: `app/views/projects/milestones/_form.html.haml` (L1-37)
- E-04: `app/models/milestone.rb` (L83-89)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (L82)
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` (L54)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | newアクションで新しいMilestoneを初期化 | E-01 (L46-49) | ○ |
| C-02 | createアクションでCreateServiceを呼び出し | E-01 (L62) | ○ |
| C-03 | redirect_pathでリダイレクト先を制御 | E-01 (L64-70, L150-154) | ○ |
| C-04 | milestone_paramsでパラメータをpermit | E-01 (L182-192) | ○ |
| C-05 | titleが必須項目 | E-04 (L85), E-03 (L11) | ○ |
| C-06 | titleの最大長が255文字 | E-03 (L11) | ○ |
| C-07 | フォームにMarkdownエディタがある | E-03 (L16-24) | ○ |
| C-08 | lock_versionが隠しフィールドとして存在 | E-03 (L29) | ○ |
| C-09 | 作成成功時は詳細画面へリダイレクト | E-01 (L68) | ○ |
| C-10 | バリデーション失敗時はnewを再レンダリング | E-01 (L71) | ○ |
| C-11 | 画面No.53がマイルストーン新規作成 | E-06 | ○ |
| C-12 | 機能No.41マイルストーン管理が主機能 | E-05 | ○ |
| C-13 | admin_milestone権限が必要 | E-01 (L16-17) | ○ |
| C-14 | CreateServiceがスパムチェックを実行 | **サービス未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- CreateServiceの詳細実装
  - 候補：`app/services/milestones/create_service.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム構成は明確に確認可能
- 0: 低リスク - パラメータ許可リストは確認済み
- 1: 中リスク - サービスクラスの詳細実装は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] CreateServiceのスパムチェック実装を確認
- [ ] uniqueness_of_titleバリデーションの動作を確認
- [ ] redirect_pathの有効値を確認
