---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：58-ラベル編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **UpdateServiceの詳細実装**：サービスクラスの詳細確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/labels_controller.rb` (L64-97, L166-173)
- E-02: `app/views/projects/labels/edit.html.haml` (L1-10)
- E-03: `app/views/shared/labels/_form.html.haml` (L1-57)
- E-04: `app/models/label.rb` (L27-29, L336-341)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (L87)
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` (L59)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | editアクションが編集画面を提供 | E-01 (L64) | ○ |
| C-02 | updateアクションでUpdateServiceを呼び出し | E-01 (L67) | ○ |
| C-03 | destroyアクションでラベル削除 | E-01 (L89-97) | ○ |
| C-04 | show_lock_on_mergeでlock_on_merge表示制御 | E-02 (L5), E-03 (L37-43) | ○ |
| C-05 | アーカイブ済みラベルにアラート表示 | E-03 (L5-13) | ○ |
| C-06 | 削除ボタンがフォーム下部にある | E-03 (L53-56) | ○ |
| C-07 | lock_on_mergeで削除防止 | E-04 (L336-341) | ○ |
| C-08 | 更新成功時は一覧画面へリダイレクト | E-01 (L70) | ○ |
| C-09 | バリデーション失敗時はeditを再レンダリング | E-01 (L72) | ○ |
| C-10 | 画面No.58がラベル編集 | E-06 | ○ |
| C-11 | 機能No.40ラベル管理が主機能 | E-05 | ○ |
| C-12 | admin_label権限が必要 | E-01 (L10-12) | ○ |
| C-13 | supports_lock_on_merge?でプロジェクト確認 | E-02 (L5) | ○ |
| C-14 | labels_archiveフィーチャーフラグで制御 | E-03 (L5) | ○ |
| C-15 | UpdateServiceがラベル更新を実行 | **サービス未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- UpdateServiceの詳細実装
  - 候補：`app/services/labels/update_service.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム構成は明確に確認可能
- 0: 低リスク - 削除防止ロジックは確認済み
- 0: 低リスク - フィーチャーフラグによる制御は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] UpdateServiceの詳細実装を確認
- [ ] lock_on_merge設定済みラベルの動作を確認
- [ ] アーカイブ解除フローを確認
