---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：59-作業アイテム一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL APIスキーマ詳細**：フロントエンドのAPI呼び出し詳細は要確認
  2. **フロントエンドVueコンポーネント**：Vue.js実装の詳細は要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/work_items_controller.rb` (L1-129)
- E-02: `app/views/projects/work_items/index.html.haml` (L1-7)
- E-03: `app/models/work_item.rb` (L1-15, L14-15)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (L88)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (L60)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | indexアクションが一覧画面を提供 | E-01 (L43) | ○ |
| C-02 | js-work-itemsがVueマウントポイント | E-02 (L6) | ○ |
| C-03 | work_item_views_only_dataでデータ提供 | E-02 (L6) | ○ |
| C-04 | WorkItemはIssueを継承 | E-03 (L3) | ○ |
| C-05 | table_nameが'issues' | E-03 (L14-15) | ○ |
| C-06 | import_csvアクションがある | E-01 (L30-41) | ○ |
| C-07 | PrepareImportCsvServiceを呼び出し | E-01 (L34) | ○ |
| C-08 | import_work_items権限チェック | E-01 (L10, L93-100) | ○ |
| C-09 | work_item_planning_viewフラグ | E-01 (L14-15) | ○ |
| C-10 | 画面No.59が作業アイテム一覧 | E-05 | ○ |
| C-11 | 機能No.46ワークアイテム管理が主機能 | E-04 | ○ |
| C-12 | EXTENSION_ALLOWLISTでCSV制限 | E-01 (L8) | ○ |
| C-13 | GraphQL APIで一覧取得 | **フロントエンド未確認** | △ |
| C-14 | 各種フィルター機能 | **フロントエンド未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- GraphQL APIのスキーマ定義とクエリ詳細
  - 候補：`app/graphql/types/work_item_type.rb` / GraphQL関連ファイル
- フロントエンドVue.jsコンポーネントの詳細
  - 候補：`app/assets/javascripts/work_items/` / Vueコンポーネント群

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - フロントエンド実装詳細はバックエンドコードからは確認困難
- 0: 低リスク - バックエンドのコントローラー構造は確認済み
- 0: 低リスク - CSVインポート処理は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] GraphQL APIのWorkItemsクエリを確認
- [ ] フロントエンドのフィルタリング実装を確認
- [ ] work_item_planning_viewフラグの影響範囲を確認
