---
generated_at: 2026-01-22 11:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-メール確認再送画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/devise/confirmations/new.html.haml` - メール確認再送画面ビューテンプレート
- E-02: `app/controllers/confirmations_controller.rb` - 確認コントローラー（1-115行目）
- E-03: `app/models/user.rb` - ユーザーモデル（120行目 devise :confirmable）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（12行目）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（7行目）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図（64行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/users/confirmation/new` でメール確認再送画面にアクセス | E-01 (Devise convention) | ○ |
| C-02 | メールアドレス入力が必須 | E-01 (7行目 required: true) | ○ |
| C-03 | タイトルが「Resend confirmation instructions」 | E-01 (1行目 _tab_single) | ○ |
| C-04 | reCAPTCHAが設定時に表示される | E-01 (13-14行目), E-02 (8-9行目) | ○ |
| C-05 | セカンダリメールはEmails設定から確認する旨の説明がある | E-01 (8-10行目) | ○ |
| C-06 | Sign inリンクが表示される | E-01 (19行目 _sign_in_link) | ○ |
| C-07 | Deviseの:confirmableモジュールにより実装 | E-03 (120行目) | ○ |
| C-08 | ソフト確認モード時はダッシュボードにリダイレクト | E-02 (74-77行目) | ○ |
| C-09 | ハード確認モード時はalmost_there画面にリダイレクト | E-02 (75行目) | ○ |
| C-10 | 関連機能No.82が正しくマッピングされている | E-04 (12行目) | ○ |
| C-11 | 画面遷移が正しい | E-06 (64行目) | ○ |
| C-12 | POST /users/confirmation で確認メール再送が実行される | E-01 (2行目 confirmation_path) | ○ |
| C-13 | reCAPTCHA検証がprepend_before_actionで実行される | E-02 (8行目) | ○ |
| C-14 | プロフィールメールページへのリンクがある | E-01 (9行目 profile_emails_url) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] email_confirmation_setting（ハード/ソフト確認モード）の設定を確認
- [ ] reCAPTCHA設定の有効化状況を確認
- [ ] 確認トークンの有効期限設定を確認
