---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：60-作業アイテム詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL APIスキーマ詳細**：フロントエンドのAPI呼び出し詳細は要確認
  2. **フロントエンドVueコンポーネント**：Vue.js実装の詳細は要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/work_items_controller.rb` (L45-49, L121-125)
- E-02: `app/views/projects/work_items/show.html.haml` (L1-11)
- E-03: `app/views/shared/_work_item_metadata.html.haml` (L1-7)
- E-04: `app/models/work_item.rb` (L3, L14-15, L19-30, L305-318, L322-328)
- E-05: `app/models/work_items/type.rb` (L19-44, L100-106)
- E-06: `app/finders/work_items/work_items_finder.rb` (L14-25, L68-78)
- E-07: `app/helpers/work_items_helper.rb` (L18-20, L89-96)
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (L89)
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv` (L61)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | showアクションが詳細画面を提供 | E-01 (L45-49) | ○ |
| C-02 | iid='new'で早期リターン | E-01 (L46) | ○ |
| C-03 | issuableでWorkItemsFinderを使用 | E-01 (L121-125) | ○ |
| C-04 | js-work-itemsがVueマウントポイント | E-02 (L11) | ○ |
| C-05 | work_item_views_only_dataでデータ提供 | E-02 (L11), E-07 (L18-20) | ○ |
| C-06 | @work_item存在時にメタデータレンダリング | E-02 (L1-2), E-03 | ○ |
| C-07 | WorkItemはIssueを継承 | E-04 (L3) | ○ |
| C-08 | table_nameが'issues' | E-04 (L14) | ○ |
| C-09 | widgetsメソッドでウィジェット取得 | E-04 (L305-318) | ○ |
| C-10 | get_widgetで個別ウィジェット取得 | E-04 (L322-328) | ○ |
| C-11 | 親子関係のhas_one/has_many | E-04 (L21-30) | ○ |
| C-12 | BASE_TYPESでタイプ定義 | E-05 (L34-44) | ○ |
| C-13 | widget_classesでウィジェットクラス取得 | E-05 (L104-106) | ○ |
| C-14 | by_widgetsでフィルタリング | E-06 (L68-78) | ○ |
| C-15 | GraphQL APIでウィジェットデータ取得 | **フロントエンド未確認** | △ |
| C-16 | workItemUpdateミューテーションで更新 | **フロントエンド未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- GraphQL APIのスキーマ定義とクエリ/ミューテーション詳細
  - 候補：`app/graphql/types/work_item_type.rb` / GraphQL関連ファイル
- フロントエンドVue.jsコンポーネントの詳細
  - 候補：`app/assets/javascripts/work_items/` / Vueコンポーネント群
- ウィジェット更新サービスの詳細
  - 候補：`app/services/work_items/` / サービスクラス群

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - フロントエンド実装詳細はバックエンドコードからは確認困難
- 0: 低リスク - バックエンドのコントローラー構造は確認済み
- 0: 低リスク - ウィジェットシステムの構造は確認済み
- 0: 低リスク - 親子関係のモデル構造は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] GraphQL APIのworkItemクエリを確認
- [ ] GraphQL APIのworkItemUpdateミューテーションを確認
- [ ] フロントエンドのウィジェットコンポーネント実装を確認
- [ ] 各ウィジェットタイプの更新サービスを確認
- [ ] 親子関係制約（HierarchyRestriction）の詳細を確認
