---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：61-MR一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **ポーリング間隔の設定値**：コード上で確認できるが、設定変更可能性の確認が必要
  2. **デフォルトページネーション件数**：コード内で明示的な定義の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/merge_requests_controller.rb` - コントローラー実装
- E-02: `app/views/projects/merge_requests/index.html.haml` - ビューテンプレート（行1-17）
- E-03: `app/helpers/merge_requests_helper.rb` - ヘルパーメソッド（行266-281）
- E-04: `config/routes/merge_requests.rb` - ルーティング定義（行2-7）
- E-05: `app/finders/merge_requests_finder.rb` - Finder実装
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行90-91）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行62）
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | マージリクエスト一覧を表示する画面である | E-02, E-07 | ○ |
| C-02 | URL形式は `/:namespace_id/:project_id/-/merge_requests` | E-04 | ○ |
| C-03 | indexアクションで処理される | E-01（行97-104） | ○ |
| C-04 | HTML/Atom/JSON形式で応答可能 | E-01（行100-103） | ○ |
| C-05 | フィルタリング項目にscope, state, assignee_idが含まれる | E-05 | ○ |
| C-06 | ソート条件にcreated_desc等が使用可能 | E-05 | ○ |
| C-07 | 一括更新機能が存在する | E-01（行19）, E-02（行16-17） | ○ |
| C-08 | CSVエクスポート機能が存在する | E-01（行370-377） | ○ |
| C-09 | RSSフィード機能が存在する | E-01（行18）, E-02（行8） | ○ |
| C-10 | Vue.jsコンポーネントでフロントエンド実装 | E-02（行15） | ○ |
| C-11 | マウントポイントは `js-merge-request-list-root` | E-02（行15） | ○ |
| C-12 | 関連機能No.28（マージリクエスト作成）が主機能 | E-06 | ○ |
| C-13 | 関連機能No.40（ラベル管理）が補助機能 | E-06 | ○ |
| C-14 | Developer以上で一括更新が可能 | E-02（行1）, E-03（行276） | ○ |
| C-15 | `project_merge_requests_list_data`でデータ取得 | E-02（行15）, E-03（行266-281） | ○ |
| C-16 | プロジェクトID、フルパスがデータに含まれる | E-03（行270-271） | ○ |
| C-17 | 新規MR作成パスがデータに含まれる | E-03（行273） | ○ |
| C-18 | エクスポートCSVパスがデータに含まれる | E-03（行274） | ○ |
| C-19 | MergeRequestsFinderでデータ取得 | E-01（行587-589） | ○ |
| C-20 | 検索時にレート制限チェックが行われる | E-01（行33） | ○ |
| C-21 | MergeRequestSerializerでJSON変換 | E-01（行574-575） | ○ |
| C-22 | CSVエクスポートはバックグラウンドワーカーで実行 | E-01（行371） | ○ |
| C-23 | エクスポート完了後メール送信 | E-01（行374-375） | ○ |
| C-24 | ポーリング間隔は10秒 | E-01（行432） | ○ |
| C-25 | 画面種別は「一覧」 | E-07 | ○ |
| C-26 | カテゴリは「マージリクエスト」 | E-07 | ○ |
| C-27 | ページネーションのデフォルトは20件/ページ | **根拠なし** | △ |
| C-28 | 一覧→詳細への画面遷移が可能 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- **ページネーション件数の明示的定義**：Kaminariのデフォルト設定またはアプリケーション設定ファイルの確認が必要
  - 候補：`config/initializers/kaminari_config.rb` / `config/application.rb` / モデル定義

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的な画面仕様は全てコードで確認可能
- **1（中リスク）**: ページネーション件数は一般的な値だが、明示的な確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ページネーションのデフォルト件数がアプリケーション設定で定義されているか確認
- [ ] 一括更新の権限チェック（admin_merge_request）がポリシーで正しく定義されているか確認
- [ ] CSVエクスポートのバックグラウンドジョブが適切にキュー設定されているか確認
