---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：62-MR新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **タイトル最大文字数**：一般的な値だがモデルでの明示的バリデーション確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/merge_requests/creations_controller.rb` - コントローラー実装（行1-201）
- E-02: `app/views/projects/merge_requests/creations/new.html.haml` - ビューテンプレート
- E-03: `app/views/projects/merge_requests/creations/_page.html.haml` - ページレイアウト（行1-19）
- E-04: `config/routes/merge_requests.rb` - ルーティング定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行92-93）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行63）
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報
- E-08: `app/services/merge_requests/create_service.rb` - 作成サービス（推定パス）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新規MR作成画面である | E-02, E-06 | ○ |
| C-02 | URL形式は `/-/merge_requests/new` | E-04 | ○ |
| C-03 | newアクションで処理される | E-01（行34-49） | ○ |
| C-04 | createアクションでMR作成 | E-01（行51-67） | ○ |
| C-05 | MergeRequests::CreateServiceでMR作成 | E-01（行52-54） | ○ |
| C-06 | 作成権限チェックが行われる | E-01（行12） | ○ |
| C-07 | branch_fromでソースブランチ選択 | E-01（行96-106） | ○ |
| C-08 | branch_toでターゲットブランチ選択 | E-01（行108-120） | ○ |
| C-09 | diffsアクションで差分取得 | E-01（行81-87） | ○ |
| C-10 | pipelinesアクションでパイプライン取得 | E-01（行69-79） | ○ |
| C-11 | ポーリング間隔は10秒 | E-01（行72） | ○ |
| C-12 | 関連機能No.28が主機能 | E-05 | ○ |
| C-13 | 関連機能No.149が補助機能 | E-05 | ○ |
| C-14 | 既存MR競合チェックが行われる | E-03（行8-16） | ○ |
| C-15 | RapidDiffsプレゼンターが使用される | E-01（行37-48） | ○ |
| C-16 | Web IDEからの作成がトラッキングされる | E-01（行28, 168-170） | ○ |
| C-17 | push後リンクからのアクセスがトラッキングされる | E-01（行30-32, 172-177） | ○ |
| C-18 | define_new_varsでフォーム用変数設定 | E-01（行128-151） | ○ |
| C-19 | LabelsFinderでラベル取得 | E-01（行148） | ○ |
| C-20 | set_pipeline_variablesが呼ばれる | E-01（行150） | ○ |
| C-21 | 作成成功時はMR詳細にリダイレクト | E-01（行59） | ○ |
| C-22 | 作成失敗時はnewを再表示 | E-01（行61-66） | ○ |
| C-23 | フォーク時にターゲットプロジェクト選択可能 | E-01（行153-166） | ○ |
| C-24 | 画面種別は「登録」 | E-06 | ○ |
| C-25 | カテゴリは「マージリクエスト」 | E-06 | ○ |
| C-26 | タイトル最大255文字 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **タイトルの最大文字数バリデーション**：モデル定義またはデータベーススキーマでの確認が必要
  - 候補：`app/models/merge_request.rb` / `db/schema.rb`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的な画面仕様は全てコードで確認可能
- **0（低リスク）**: タイトル文字数は一般的なDBカラム制限値

## 6) レビュアーチェックリスト（最小）
- [ ] MergeRequest モデルでタイトルの長さバリデーションが定義されているか確認
- [ ] CreateServiceでの差分計算開始処理を確認
- [ ] MRテンプレートの読み込み処理が適切に実装されているか確認
