---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 32
  claims_with_evidence: 31
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：63-MR詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：31 / 32、根拠なし：1
- 優先レビュー（高）
  1. **ActionCableによるリアルタイム更新**：WebSocket通信の実装詳細の確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/merge_requests_controller.rb` - コントローラー実装（行106-503）
- E-02: `app/views/projects/merge_requests/show.html.haml` - メインビュー
- E-03: `app/views/projects/merge_requests/_page.html.haml` - ページレイアウト（行1-117）
- E-04: `config/routes/merge_requests.rb` - ルーティング定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行94-98）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行64）
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報
- E-08: `app/helpers/merge_requests_helper.rb` - ヘルパーメソッド

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MR詳細表示画面である | E-02, E-06 | ○ |
| C-02 | showアクションで処理される | E-01（行106-108） | ○ |
| C-03 | URL形式は `/-/merge_requests/:id` | E-04 | ○ |
| C-04 | diffsアクションで差分タブ | E-01（行110-112） | ○ |
| C-05 | commitsアクションでコミットタブ | E-01（行127-159） | ○ |
| C-06 | pipelinesアクションでパイプラインタブ | E-01（行161-187） | ○ |
| C-07 | mergeアクションでマージ実行 | E-01（行306-320） | ○ |
| C-08 | cancel_auto_mergeで自動マージキャンセル | E-01（行298-304） | ○ |
| C-09 | rebaseアクションでリベース | E-01（行354-361） | ○ |
| C-10 | 関連機能No.29が主機能 | E-05 | ○ |
| C-11 | 関連機能No.30-35が補助機能 | E-05 | ○ |
| C-12 | タブ構成（Overview/Commits/Pipelines/Changes） | E-03（行31-50） | ○ |
| C-13 | Overviewタブにディスカッション | E-03（行61-89） | ○ |
| C-14 | Vue.jsコンポーネントで実装 | E-03（行75-88） | ○ |
| C-15 | js-vue-mr-discussionsでディスカッション | E-03（行75） | ○ |
| C-16 | js-merge-sticky-headerでスティッキーヘッダー | E-03（行25） | ○ |
| C-17 | サイドバーでメタデータ編集 | E-03（行89） | ○ |
| C-18 | MRウィジェットが表示される | E-03（行70） | ○ |
| C-19 | ポーリング間隔は10秒 | E-01（行432） | ○ |
| C-20 | JSON/patch/diff形式でも出力可能 | E-01（行431-463） | ○ |
| C-21 | show_merge_requestで処理 | E-01（行410-465） | ○ |
| C-22 | render_html_pageでHTML描画 | E-01（行467-503） | ○ |
| C-23 | check_mergeabilityが呼ばれる | E-01（行412） | ○ |
| C-24 | バージョン上限警告が表示される | E-01（行685-698） | ○ |
| C-25 | 差分コミット上限警告が表示される | E-01（行693-698） | ○ |
| C-26 | sticky_header_dataでヘッダーデータ | E-08（行300-337） | ○ |
| C-27 | diffs_tab_pane_dataで差分データ | E-08（行180-211） | ○ |
| C-28 | RapidDiffsが有効な場合は別コンポーネント | E-03（行97-102） | ○ |
| C-29 | パイプライン一覧はbuilds_enabled時のみ | E-03（行41, 94） | ○ |
| C-30 | コミットタブはsource_project存在時のみ | E-03（行36） | ○ |
| C-31 | 画面種別は「詳細」 | E-06 | ○ |
| C-32 | ActionCableでリアルタイム更新 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **ActionCableによるリアルタイム更新の実装詳細**：WebSocket通信の設定ファイルやチャンネル定義の確認が必要
  - 候補：`app/channels/` / `config/cable.yml` / フロントエンドのActionCableクライアント実装

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的な画面仕様は全てコードで確認可能
- **1（中リスク）**: リアルタイム更新の仕組みは追加調査推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ActionCableチャンネルの実装を確認（MergeRequestsChannel等）
- [ ] マージ可能性チェック（check_mergeability）の詳細ロジックを確認
- [ ] 自動マージ戦略（auto_merge_strategy）の選択肢を確認
