---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：65-コンフリクト解決

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/merge_requests/conflicts_controller.rb` - コントローラー実装（行1-89）
- E-02: `app/views/projects/merge_requests/conflicts/show.html.haml` - メインビュー（行1-17）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行100）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行66）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンフリクト解決画面である | E-02, E-04 | ○ |
| C-02 | showアクションで処理される | E-01（行14-40） | ○ |
| C-03 | HTML/JSON形式で応答可能 | E-01（行15-39） | ○ |
| C-04 | conflict_for_pathで特定ファイル取得 | E-01（行42-50） | ○ |
| C-05 | resolve_conflictsで解決実行 | E-01（行52-74） | ○ |
| C-06 | ResolveServiceでコンフリクト解決 | E-01（行64-66） | ○ |
| C-07 | 権限チェックが行われる | E-01（行6, 80-84） | ○ |
| C-08 | ListServiceでコンフリクト一覧取得 | E-01（行81） | ○ |
| C-09 | can_be_resolved_in_ui?でUI解決可否判定 | E-01（行23, 43, 53） | ○ |
| C-10 | 既解決時のエラーメッセージ | E-01（行26-30, 57-61） | ○ |
| C-11 | UI解決不可時のエラーメッセージ | E-01（行32-36） | ○ |
| C-12 | 解決成功時のフラッシュメッセージ | E-01（行68） | ○ |
| C-13 | 解決成功時のリダイレクト | E-01（行70） | ○ |
| C-14 | ResolutionErrorのハンドリング | E-01（行71-72） | ○ |
| C-15 | 関連機能No.32が主機能 | E-03 | ○ |
| C-16 | 利用統計のトラッキング | E-01（行18-19, 55） | ○ |
| C-17 | サイドバーデータの取得 | E-01（行17） | ○ |
| C-18 | #conflictsがVueマウントポイント | E-02（行13-16） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ListServiceのcan_be_resolved_in_ui?の判定ロジックを確認
- [ ] ResolveServiceのGit操作処理を確認
