---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：66-パイプライン一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/pipelines_controller.rb` - コントローラー実装（行47-79）
- E-02: `app/views/projects/pipelines/index.html.haml` - メインビュー（行1-11）
- E-03: `app/helpers/ci/pipelines_helper.rb` - ヘルパーメソッド（行50-76）
- E-04: `config/routes/pipelines.rb` - ルーティング定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行101）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行67）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パイプライン一覧画面である | E-02, E-06 | ○ |
| C-02 | indexアクションで処理される | E-01（行58-79） | ○ |
| C-03 | HTML/JSON形式で応答可能 | E-01（行66-78） | ○ |
| C-04 | Ci::PipelinesFinderでデータ取得 | E-01（行59-61） | ○ |
| C-05 | ポーリング間隔は10秒 | E-01（行47, 69） | ○ |
| C-06 | Vue.jsコンポーネントで実装 | E-02（行10） | ○ |
| C-07 | #pipelines-list-vueがマウントポイント | E-02（行10） | ○ |
| C-08 | pipelines_list_dataでデータ設定 | E-02（行10）, E-03（行50-76） | ○ |
| C-09 | 関連機能No.47が主機能 | E-05 | ○ |
| C-10 | フィルター項目（scope, status, ref等） | E-01（行333-335） | ○ |
| C-11 | PipelineSerializerでJSON変換 | E-01（行71-77） | ○ |
| C-12 | ページネーションあり | E-01（行62） | ○ |
| C-13 | パイプラインアナリティクスパスが含まれる | E-03（行72） | ○ |
| C-14 | 新規パイプラインパスが含まれる | E-03（行63） | ○ |
| C-15 | パイプラインエディタパスが含まれる | E-03（行67） | ○ |
| C-16 | has_gitlab_ci判定が含まれる | E-03（行66） | ○ |
| C-17 | 画面種別は「一覧」 | E-06 | ○ |
| C-18 | カテゴリは「CI/CD」 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Ci::PipelinesFinderのフィルタリングロジックを確認
- [ ] PipelineSerializerの出力項目を確認
