---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-パイプライン詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/pipelines_controller.rb` - コントローラー実装（行116-211）
- E-02: `app/views/projects/pipelines/show.html.haml` - メインビュー（行1-44）
- E-03: `app/helpers/projects/pipeline_helper.rb` - ヘルパーメソッド（行7-41）
- E-04: `config/routes/pipelines.rb` - ルーティング定義（行3, 12-21）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行69）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パイプライン詳細画面である | E-02, E-06 | ○ |
| C-02 | showアクションで処理される | E-01（行116-129） | ○ |
| C-03 | HTML/JSON形式で応答可能 | E-01（行119-128） | ○ |
| C-04 | ポーリング間隔は10秒 | E-01（行122） | ○ |
| C-05 | render_showでステージ情報取得 | E-01（行238-246） | ○ |
| C-06 | retryアクションで非同期リトライ | E-01（行164-180, 172） | ○ |
| C-07 | cancelアクションでキャンセル | E-01（行182-192） | ○ |
| C-08 | CancelPipelineServiceを使用 | E-01（行183） | ○ |
| C-09 | RetryPipelineWorkerを使用 | E-01（行172） | ○ |
| C-10 | stageアクションでステージ情報取得 | E-01（行155-162） | ○ |
| C-11 | statusアクションでステータス取得 | E-01（行149-153） | ○ |
| C-12 | #js-pipeline-headerでヘッダーマウント | E-02（行11） | ○ |
| C-13 | #js-pipeline-tabsでタブマウント | E-02（行43） | ○ |
| C-14 | js_pipeline_header_dataでデータ設定 | E-02（行11）, E-03（行34-41） | ○ |
| C-15 | js_pipeline_tabs_dataでデータ設定 | E-02（行43）, E-03（行7-32） | ○ |
| C-16 | failed_jobs_countが設定される | E-03（行9） | ○ |
| C-17 | total_job_countが設定される | E-03（行20） | ○ |
| C-18 | tests_countが設定される | E-03（行27） | ○ |
| C-19 | エラー時にアラート表示 | E-02（行13-41） | ○ |
| C-20 | composite_identity_forbidden判定 | E-02（行14, 16-28） | ○ |
| C-21 | パイプラインエディタリンク表示 | E-02（行38-40） | ○ |
| C-22 | manual_variables_countが設定される | E-03（行28） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] CancelPipelineServiceの詳細ロジックを確認
- [ ] RetryPipelineWorkerの非同期処理を確認
- [ ] GraphQL subscriptionの動作を確認
