---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：69-ジョブ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/jobs_controller.rb` - コントローラー実装（行32, 9-10, 306-308）
- E-02: `app/views/projects/jobs/index.html.haml` - メインビュー（行1-5）
- E-03: `app/helpers/ci/jobs_helper.rb` - ヘルパーメソッド（行24-28）
- E-04: `config/routes/project.rb` - ルーティング定義（行53）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行70）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ジョブ一覧画面である | E-02, E-06 | ○ |
| C-02 | indexアクションで処理される | E-01（行32） | ○ |
| C-03 | indexアクションは空（ビューレンダリングのみ） | E-01（行32） | ○ |
| C-04 | authorize_read_build!が設定される | E-01（行15） | ○ |
| C-05 | Vue.jsコンポーネント（#js-jobs-table） | E-02（行5） | ○ |
| C-06 | full_pathがdata属性に含まれる | E-02（行5） | ○ |
| C-07 | job_statusesがdata属性に含まれる | E-02（行5） | ○ |
| C-08 | pipeline_editor_pathがdata属性に含まれる | E-02（行5） | ○ |
| C-09 | empty_state_svg_pathがdata属性に含まれる | E-02（行5） | ○ |
| C-10 | job_statusesはCi::HasStatus::AVAILABLE_STATUSES | E-03（行25） | ○ |
| C-11 | push_job_subscription_feature_flagが設定 | E-01（行26, 306-308） | ○ |
| C-12 | ci_job_created_subscriptionフラグが使用される | E-01（行307） | ○ |
| C-13 | URLは/-/jobs | E-04（行53） | ○ |
| C-14 | ルーティングにindexアクションあり | E-04（行53） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] GraphQL APIのクエリ構造を確認
- [ ] Vue.jsコンポーネントの実装を確認
- [ ] フィルタリング機能の実装を確認
