---
generated_at: 2026-01-22 11:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：7-2要素認証画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **メールOTPフォールバック機能**：EE機能の可能性があり、CE版での利用可否確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/devise/sessions/two_factor.html.haml` - 2要素認証画面ビューテンプレート
- E-02: `app/views/devise/shared/_totp_recovery_code_or_webauthn.html.haml` - 2FAフォームパーシャル
- E-03: `app/controllers/sessions_controller.rb` - セッションコントローラー
- E-04: `app/models/user.rb` - ユーザーモデル（112-117行目 devise 2FA設定）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（13行目）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（8行目）
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図（50-55行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 2FAが有効なユーザーに自動的に2FA画面が表示される | E-03 (26-27行目) | ○ |
| C-02 | TOTPコード入力フィールドがある | E-02 (7-9行目) | ○ |
| C-03 | リカバリーコードも入力可能 | E-02 (10-11行目) | ○ |
| C-04 | WebAuthnが登録されている場合はWebAuthn UIが表示される | E-02 (23-24行目) | ○ |
| C-05 | inputmode="numeric"が設定される | E-02 (9行目) | ○ |
| C-06 | Remember meが隠しフィールドで引き継がれる | E-02 (13-14行目) | ○ |
| C-07 | Users::ValidateManualOtpServiceでOTP検証が行われる | E-03 (310-312行目) | ○ |
| C-08 | invalidate_otp_backup_code!でリカバリーコードが無効化される | E-03 (314行目) | ○ |
| C-09 | 関連機能No.79が正しくマッピングされている | E-05 (13行目) | ○ |
| C-10 | 画面遷移（ダッシュボードへの遷移）が正しい | E-07 (50-55行目) | ○ |
| C-11 | devise :two_factor_authenticatableが設定されている | E-04 (112-113行目) | ○ |
| C-12 | devise :two_factor_backupableが設定されている | E-04 (115-116行目) | ○ |
| C-13 | 説明テキストにリカバリーコードの使用方法が記載されている | E-02 (10-11行目) | ○ |
| C-14 | フォームがjs-2fa-formクラスを持つ | E-02 (5行目) | ○ |
| C-15 | メールOTPフォールバック機能がある | E-02 (19-21行目 render_email_otp_fallback_for_totp?) | ○ |
| C-16 | TOTPコードの有効期間は30秒 | **根拠なし**（TOTP標準仕様だが、設定ファイル未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- **C-16**: TOTPコードの有効期間（30秒）はTOTP標準仕様だが、GitLabの設定で変更されている可能性がある
  - 候補：`config/initializers/devise.rb` / `otp_secret` の設定

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分の主張がソースコードで裏付けられている
- **1（中リスク）**: メールOTPフォールバックはEE機能の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] TOTPコードの有効期間設定を確認
- [ ] WebAuthn登録の利用状況を確認
- [ ] メールOTPフォールバック機能の利用可否を確認（CE/EE）
- [ ] リカバリーコードの個数設定を確認
