---
generated_at: 2026-01-22 11:20:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-ジョブ詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/jobs_controller.rb` - コントローラー実装（行34-154）
- E-02: `app/views/projects/jobs/show.html.haml` - メインビュー（行1-10）
- E-03: `app/helpers/ci/jobs_helper.rb` - ヘルパーメソッド（行5-22）
- E-04: `config/routes/project.rb` - ルーティング定義（行53-81）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行71）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ジョブ詳細画面である | E-02, E-06 | ○ |
| C-02 | showアクションで処理される | E-01（行34-63） | ○ |
| C-03 | Ci::Bridge判定あり | E-01（行35-41） | ○ |
| C-04 | ポーリング間隔は10秒 | E-01（行46） | ○ |
| C-05 | Ci::JobSerializerでシリアライズ | E-01（行48-60） | ○ |
| C-06 | BuildDetailsEntityを使用 | E-01（行59） | ○ |
| C-07 | traceアクションでログ取得 | E-01（行65-86） | ○ |
| C-08 | trace.being_watched!でrunning時通知 | E-01（行66） | ○ |
| C-09 | retryアクションでリトライ | E-01（行88-104） | ○ |
| C-10 | RetryJobServiceを使用 | E-01（行93） | ○ |
| C-11 | playアクションで手動実行 | E-01（行106-117） | ○ |
| C-12 | cancelアクションでキャンセル | E-01（行119-130） | ○ |
| C-13 | BuildCancelServiceを使用 | E-01（行120） | ○ |
| C-14 | unscheduleアクションでスケジュール解除 | E-01（行132-144） | ○ |
| C-15 | BuildUnscheduleServiceを使用 | E-01（行135） | ○ |
| C-16 | eraseアクションでログ消去 | E-01（行146-154） | ○ |
| C-17 | BuildEraseServiceを使用 | E-01（行147） | ○ |
| C-18 | #js-job-pageでVueマウント | E-02（行10） | ○ |
| C-19 | jobs_dataでデータ設定 | E-02（行10）, E-03（行5-22） | ○ |
| C-20 | job_endpointが設定される | E-03（行7） | ○ |
| C-21 | log_endpointが設定される | E-03（行8） | ○ |
| C-22 | test_report_summary_urlが設定される | E-03（行9） | ○ |
| C-23 | log_viewer_pathが設定される | E-03（行19） | ○ |
| C-24 | can_set_pipeline_variablesが設定される | E-03（行20） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] BuildTraceSerializerのログフォーマットを確認
- [ ] WebSocketターミナル機能の実装を確認
- [ ] アーティファクトダウンロードのWorkhorse連携を確認
