---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：71-パイプラインスケジュール一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **WebSocket/GraphQL Subscription機能の詳細**：コード上は確認できるが運用時の動作詳細は要確認
  2. **プラン制限値の具体的数値**：プランごとの具体的制限値は設定依存
  3. **レート制限の時間**：コード上「1分」と記載があるが設定で変更可能な可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/pipeline_schedules_controller.rb`
- E-02: `app/views/projects/pipeline_schedules/index.html.haml`
- E-03: `app/models/ci/pipeline_schedule.rb`
- E-04: `app/assets/javascripts/ci/pipeline_schedules/components/pipeline_schedules.vue`
- E-05: `app/assets/javascripts/ci/pipeline_schedules/components/table/pipeline_schedules_table.vue`
- E-06: `app/helpers/ci/pipeline_schedules_helper.rb`
- E-07: `config/routes/pipelines.rb`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは`/:namespace/:project/-/pipeline_schedules`である | E-07 (35行目) | ○ |
| C-02 | indexアクションでスケジュール一覧を取得する | E-01 (18-22行目) | ○ |
| C-03 | PipelineSchedulesFinderを使用してスケジュールを検索する | E-01 (20-21行目) | ○ |
| C-04 | Vue.jsコンポーネントがフロントエンドを担当する | E-02, E-04 | ○ |
| C-05 | GraphQL APIでデータを取得する | E-04 (96-185行目) | ○ |
| C-06 | All/Active/Inactiveの3つのタブがある | E-04 (224-245行目) | ○ |
| C-07 | playアクションでスケジュールを即時実行できる | E-01 (49-62行目) | ○ |
| C-08 | take_ownershipアクションで所有権を取得できる | E-01 (64-71行目) | ○ |
| C-09 | destroyアクションでスケジュールを削除できる | E-01 (74-80行目) | ○ |
| C-10 | レート制限が存在する（1分間隔） | E-01 (84-91行目) | ○ |
| C-11 | authorize_read_pipeline_schedule!で権限チェックする | E-01 (10行目) | ○ |
| C-12 | authorize_create_pipeline_schedule!で作成権限をチェックする | E-01 (11行目) | ○ |
| C-13 | authorize_admin_pipeline_schedule!で管理権限をチェックする | E-01 (13行目) | ○ |
| C-14 | スケジュールはproject, owner, pipelines, variablesと関連を持つ | E-03 (34-38行目) | ○ |
| C-15 | cronバリデーションが存在する | E-03 (40-42行目) | ○ |
| C-16 | daily_limitメソッドで日次制限を取得できる | E-03 (113-115行目) | ○ |
| C-17 | 削除時にnullify_dependent_associations_in_batchesが実行される | E-03 (135-139行目) | ○ |
| C-18 | エラーメッセージが国際化対応されている | E-04 (42-60行目) | ○ |
| C-19 | ページネーションにGlKeysetPaginationを使用する | E-04 (529-534行目) | ○ |
| C-20 | ソート機能がLocalStorageSyncで永続化される | E-04 (485行目) | ○ |
| C-21 | 関連機能はNo.49パイプラインスケジュールである | E-08 (109行目) | ○ |
| C-22 | feature_categoryはcontinuous_integrationである | E-01 (15行目) | ○ |
| C-23 | project_pathとpipelines_pathがVueコンポーネントに渡される | E-02 (4行目), E-06 (5-18行目) | ○ |
| C-24 | subscribeToMoreでリアルタイム更新が行われる | E-04 (144-184行目) | ○ |
| C-25 | WebSocket/GraphQL Subscriptionによりステータスがリアルタイム更新される | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25について：コード上subscribeToMoreの実装は確認できるが、実際のWebSocket接続の設定やサーバー側のSubscription実装の詳細は別ファイルに存在する可能性がある
  - 候補：`app/graphql/subscriptions/` / ActionCable設定 / cable.yml

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面の基本機能（一覧表示、CRUD）は十分に根拠が確認できる
- 1: 中リスク - リアルタイム更新機能の詳細な動作確認が必要
- 0: 低リスク - 権限制御は明確にbefore_actionで実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] URLルーティングが正しく設定されているか確認
- [ ] 権限チェックのbefore_actionが適切に設定されているか確認
- [ ] GraphQL subscriptionの実装が完全か確認（サーバー側）
- [ ] プラン制限の具体的な値が環境設定で適切に設定されているか確認
- [ ] レート制限の設定値が適切か確認
