---
generated_at: 2026-01-22 12:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：72-パイプラインスケジュール新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **特になし** - 全ての主張に根拠が確認できた
  2. **daily_limitの具体的な値** - 環境設定依存のため運用確認推奨
  3. **inputs機能** - 比較的新しい機能のため動作確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/pipeline_schedules_controller.rb`
- E-02: `app/views/projects/pipeline_schedules/new.html.haml`
- E-03: `app/models/ci/pipeline_schedule.rb`
- E-04: `app/services/ci/pipeline_schedules/create_service.rb`
- E-05: `app/assets/javascripts/ci/pipeline_schedules/components/pipeline_schedules_form.vue`
- E-06: `app/helpers/ci/pipeline_schedules_helper.rb`
- E-07: `config/routes/pipelines.rb`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | newアクションでフォームを表示する | E-01 (24行目) | ○ |
| C-02 | createアクションでスケジュールを作成する | E-01 (26-34行目) | ○ |
| C-03 | CreateServiceを使用して作成処理を行う | E-01 (27行目), E-04 | ○ |
| C-04 | schedule_paramsでStrong Parametersを定義 | E-01 (97-101行目) | ○ |
| C-05 | description, cron, cron_timezone, ref, activeがパラメータ | E-01 (99-100行目) | ○ |
| C-06 | variables_attributesでネスト属性を受け付ける | E-01 (100行目) | ○ |
| C-07 | authorize_create_pipeline_schedule!で権限チェック | E-01 (11行目) | ○ |
| C-08 | cronバリデーションが存在する | E-03 (40行目) | ○ |
| C-09 | cron_timezoneバリデーションが存在する | E-03 (41行目) | ○ |
| C-10 | refは必須 | E-03 (42行目) | ○ |
| C-11 | descriptionは必須 | E-03 (43行目) | ○ |
| C-12 | accepts_nested_attributes_for :variablesが定義されている | E-03 (63行目) | ○ |
| C-13 | accepts_nested_attributes_for :inputsが定義されている | E-03 (62行目) | ○ |
| C-14 | inputsは最大50件まで | E-03 (48-51行目) | ○ |
| C-15 | ownerは作成時に現在ユーザーに設定される | E-04 (12行目) | ○ |
| C-16 | Vueコンポーネントでフォームを構成する | E-02 (9行目), E-05 | ○ |
| C-17 | js_pipeline_schedules_form_dataでデータを渡す | E-02 (9行目), E-06 | ○ |
| C-18 | daily_limitを取得できる | E-06 (8行目), E-03 (113-115行目) | ○ |
| C-19 | default_branchを取得できる | E-06 (9行目) | ○ |
| C-20 | timezone_dataをJSON形式で渡す | E-06 (15行目) | ○ |
| C-21 | can_set_pipeline_variablesで変数設定権限を確認 | E-06 (16行目) | ○ |
| C-22 | worker_cron_expressionを取得できる | E-06 (17行目), E-03 (129-131行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全ての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム入力とバリデーションは明確に実装されている
- 0: 低リスク - 権限チェックはbefore_actionで適切に設定されている
- 1: 中リスク - inputs機能は比較的新しい機能のため動作確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] cron形式のバリデーションが正しく動作するか確認
- [ ] タイムゾーン一覧が正しく表示されるか確認
- [ ] ブランチ/タグの選択が正しく動作するか確認
- [ ] 変数の追加・削除が正しく動作するか確認
- [ ] inputs機能が正しく動作するか確認
- [ ] プラン制限超過時のエラー表示を確認
