---
generated_at: 2026-01-22 12:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：73-パイプラインスケジュール編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **特になし** - 全ての主張に根拠が確認できた
  2. **next_run_atの再計算ロジック** - cron変更時の動作確認推奨
  3. **変数の暗号化/復号化** - セキュリティ観点での確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/pipeline_schedules_controller.rb`
- E-02: `app/views/projects/pipeline_schedules/edit.html.haml`
- E-03: `app/models/ci/pipeline_schedule.rb`
- E-04: `app/assets/javascripts/ci/pipeline_schedules/components/pipeline_schedules_form.vue`
- E-05: `app/helpers/ci/pipeline_schedules_helper.rb`
- E-06: `config/routes/pipelines.rb`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | editアクションでフォームを表示する | E-01 (37行目) | ○ |
| C-02 | updateアクションでスケジュールを更新する | E-01 (39-46行目) | ○ |
| C-03 | scheduleメソッドでスケジュールを取得 | E-01 (93-95行目) | ○ |
| C-04 | authorize_update_pipeline_schedule!で権限チェック | E-01 (12行目) | ○ |
| C-05 | UpdateServiceを使用して更新処理を行う | E-01 (40行目) | ○ |
| C-06 | ブレッドクラムにスケジュールIDを表示 | E-02 (2行目) | ○ |
| C-07 | ページタイトルにスケジュールの説明を含む | E-02 (3行目) | ○ |
| C-08 | cron_values_changed?でcron変更を検出 | E-03 (164-166行目) | ○ |
| C-09 | allow_next_run_at_update?でnext_run_at更新を制御 | E-03 (172-175行目) | ○ |
| C-10 | set_next_run_atでnext_run_atを再計算 | E-03 (96-100行目) | ○ |
| C-11 | variables_attributesで_destroyを受け付ける | E-01 (100行目) | ○ |
| C-12 | 同じVueコンポーネントを新規作成と共有 | E-02, E-04 | ○ |
| C-13 | editing propでフォームの動作を切り替え | E-04 (61-64行目) | ○ |
| C-14 | js_pipeline_schedules_form_dataでスケジュールデータを渡す | E-02 (7行目), E-05 | ○ |
| C-15 | schedules_pathでリダイレクト先を指定 | E-05 (13行目) | ○ |
| C-16 | URLは/:namespace/:project/-/pipeline_schedules/:id/edit | E-06 (35行目) | ○ |
| C-17 | 関連機能はNo.49パイプラインスケジュール | E-07 (111行目) | ○ |
| C-18 | スケジュール更新成功時に一覧へリダイレクト | E-01 (43行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全ての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 編集機能は新規作成と同様のコンポーネントを使用
- 0: 低リスク - 権限チェックは適切に実装されている
- 1: 中リスク - next_run_atの再計算ロジックの動作確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] cron変更時にnext_run_atが正しく再計算されるか確認
- [ ] 変数の追加・更新・削除が正しく動作するか確認
- [ ] 既存値がフォームに正しくプリセットされるか確認
- [ ] 権限がないユーザーがアクセスした場合の動作確認
- [ ] 存在しないスケジュールIDでアクセスした場合の404表示確認
