---
generated_at: 2026-01-22 12:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：74-パイプラインエディタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パイプラインシミュレーション機能の詳細** - dry_runモードの実装詳細を確認
  2. **Monacoエディタの設定** - エディタの詳細設定はフロントエンド実装を確認
  3. **外部設定ファイル使用時の制限** - 編集制限の具体的な挙動

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/ci/pipeline_editor_controller.rb`
- E-02: `app/views/projects/ci/pipeline_editor/show.html.haml`
- E-03: `app/helpers/ci/pipeline_editor_helper.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | showアクションで画面を表示する | E-01 (13行目) | ○ |
| C-02 | check_can_collaborate!で権限チェック | E-01 (17-18行目) | ○ |
| C-03 | can_collaborate_with_project?で判定 | E-01 (18行目) | ○ |
| C-04 | 権限がない場合は404を返す | E-01 (18行目) | ○ |
| C-05 | Monacoエディタをプリロードする | E-02 (7-8行目) | ○ |
| C-06 | page_titleにPipeline editorを設定 | E-02 (6行目) | ○ |
| C-07 | js_pipeline_editor_dataでデータを渡す | E-02 (12行目), E-03 | ○ |
| C-08 | ci-config-pathを取得できる | E-03 (22行目) | ○ |
| C-09 | default-branchを取得できる | E-03 (27行目) | ○ |
| C-10 | ci-lint-pathでLint画面パスを取得 | E-03 (25行目) | ○ |
| C-11 | new-merge-request-pathでMR作成パスを取得 | E-03 (33行目) | ○ |
| C-12 | new-pipeline-pathでパイプライン作成パスを取得 | E-03 (34行目) | ○ |
| C-13 | uses_external_config?で外部設定を判定 | E-03 (51-55行目) | ○ |
| C-14 | external_project_sourceとremote_sourceを判定 | E-03 (54行目) | ○ |
| C-15 | project_full_pathを取得できる | E-03 (38行目) | ○ |
| C-16 | total-branchesでブランチ数を取得 | E-03 (42行目) | ○ |
| C-17 | initial-branch-nameでブランチ名を取得 | E-03 (29行目) | ○ |
| C-18 | feature_categoryはpipeline_composition | E-01 (9行目) | ○ |
| C-19 | ci_job_assistant_drawerのフィーチャーフラグ | E-01 (6行目) | ○ |
| C-20 | パイプラインシミュレーション（dry_run） | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20について：dry_runオプションはLintsControllerに実装があるが、パイプラインエディタからの呼び出し方法の詳細は別ファイルに存在
  - 候補：`app/assets/javascripts/ci/pipeline_editor/` / GraphQL mutations

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な編集機能は明確に実装されている
- 1: 中リスク - 外部設定ファイル使用時の制限の詳細確認が必要
- 1: 中リスク - パイプラインシミュレーション機能の動作確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Monacoエディタが正しく読み込まれるか確認
- [ ] ブランチ切り替えが正しく動作するか確認
- [ ] Lint機能がリアルタイムで動作するか確認
- [ ] コミット機能が正しく動作するか確認
- [ ] 外部設定ファイル使用時の警告表示を確認
- [ ] MR作成オプションが正しく動作するか確認
- [ ] 権限がないユーザーがアクセスした場合の404表示確認
