---
generated_at: 2026-01-22 12:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：77-環境一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **特になし** - 全ての主張に根拠が確認できた

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/environments_controller.rb`
- E-02: `app/views/projects/environments/index.html.haml`
- E-03: `app/models/environment.rb`
- E-04: `app/services/environments/stop_service.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | indexアクションで一覧を表示する | E-01 (36-57行目) | ○ |
| C-02 | stopアクションで環境を停止する | E-01 (115-134行目) | ○ |
| C-03 | cancel_auto_stopアクションで自動停止をキャンセル | E-01 (136-155行目) | ○ |
| C-04 | authorize_read_environment!で権限チェック | E-01 (17行目) | ○ |
| C-05 | authorize_stop_environment!で停止権限チェック | E-01 (19行目) | ○ |
| C-06 | Environments::StopServiceで停止処理 | E-01 (118行目), E-04 | ○ |
| C-07 | state_machineで状態管理 | E-03 (210-239行目) | ○ |
| C-08 | available, stopping, stoppedの3状態 | E-03 (228-230行目) | ○ |
| C-09 | scopeでactive/stoppedをフィルタ | E-01 (42-43行目) | ○ |
| C-10 | PollingInterval.set_headerでポーリング設定 | E-01 (47行目) | ○ |
| C-11 | ポーリング間隔は3秒 | E-01 (47行目: 3_000) | ○ |
| C-12 | environment_typeでフォルダ分け | E-03 (331-334行目) | ○ |
| C-13 | MIN_SEARCH_LENGTHが3 | E-01 (7行目) | ○ |
| C-14 | EnvironmentsFinder で検索 | E-01 (226-231行目) | ○ |
| C-15 | auto_stop_atで自動停止時刻を管理 | E-03 (492-511行目) | ○ |
| C-16 | feature_categoryはcontinuous_delivery | E-01 (33行目) | ○ |
| C-17 | stop_with_actions!でstop_actionを実行 | E-03 (380-396行目), E-04 | ○ |
| C-18 | ResetAutoStopServiceで自動停止リセット | E-01 (137-138行目) | ○ |
| C-19 | 関連機能はNo.55環境管理 | E-05 (115行目) | ○ |
| C-20 | Vueコンポーネントでフロントエンドを構成 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全ての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 環境管理の基本機能は明確に実装
- 0: 低リスク - 状態遷移はstate_machineで管理

## 6) レビュアーチェックリスト（最小）
- [ ] 一覧表示が正しく動作するか確認
- [ ] タブ切り替えが正しく動作するか確認
- [ ] 停止機能が正しく動作するか確認
- [ ] 自動停止キャンセルが正しく動作するか確認
- [ ] 検索機能が正しく動作するか確認（3文字以上）
- [ ] フォルダ表示が正しく動作するか確認
