---
generated_at: 2026-01-22 12:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：78-環境詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **特になし** - 全ての主張に根拠が確認できた

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/environments_controller.rb`
- E-02: `app/views/projects/environments/show.html.haml`
- E-03: `app/models/environment.rb`
- E-04: `app/helpers/environment_helper.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | showアクションで詳細を表示する | E-01 (85行目) | ○ |
| C-02 | terminalアクションでターミナル情報を取得 | E-01 (157-162行目) | ○ |
| C-03 | terminal_websocket_authorizeでWebSocket認証 | E-01 (164-178行目) | ○ |
| C-04 | authorize_read_environment!で権限チェック | E-01 (17行目) | ○ |
| C-05 | authorize_stop_environment!で停止権限チェック | E-01 (19行目) | ○ |
| C-06 | authorize_admin_environment!で管理者権限チェック | E-01 (21行目) | ○ |
| C-07 | environment_detail_dataで詳細データを生成 | E-04 (16-38行目) | ○ |
| C-08 | stop_pathでの停止エンドポイント | E-04 (19行目) | ○ |
| C-09 | cancel_auto_stop_pathでの自動停止キャンセル | E-04 (20行目) | ○ |
| C-10 | terminal_pathでのターミナルパス | E-04 (21行目) | ○ |
| C-11 | has_terminals?でターミナル有無を判定 | E-03 (423-425行目) | ○ |
| C-12 | can_stop?で停止可否を判定 | E-03 (399-401行目) | ○ |
| C-13 | state_machineで状態管理 | E-03 (210-239行目) | ○ |
| C-14 | deployments関連で履歴取得 | E-03 (119行目) | ○ |
| C-15 | Vueコンポーネントでフロントエンド構成 | E-02 | ○ |
| C-16 | feature_categoryはcontinuous_delivery | E-01 (33行目) | ○ |
| C-17 | 関連機能はNo.55環境管理とNo.56デプロイメント履歴 | E-05 (115-116行目) | ○ |
| C-18 | rollback_environment_pathでロールバック | E-04 (31行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全ての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 環境詳細の基本機能は明確に実装
- 0: 低リスク - ターミナル機能は条件付きで表示

## 6) レビュアーチェックリスト（最小）
- [ ] 環境詳細が正しく表示されるか確認
- [ ] デプロイ履歴が正しく表示されるか確認
- [ ] 停止ボタンが権限に応じて表示されるか確認
- [ ] ターミナルボタンがKubernetes環境でのみ表示されるか確認
- [ ] ロールバック機能が正しく動作するか確認
- [ ] 自動停止キャンセルが正しく動作するか確認
