---
generated_at: 2026-01-22 11:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：8-Passkey認証画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **JavaScriptコンポーネントの詳細実装**：フロントエンドコードの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/devise/sessions/passkeys.html.haml` - Passkey認証画面ビューテンプレート
- E-02: `app/controllers/sessions_controller.rb` - セッションコントローラー（73-80行目）
- E-03: `config/routes/user.rb` - ルーティング設定（61行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（14行目）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（9行目）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図（69-70行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | POST `/users/passkeys/sign_in` でPasskey認証が開始される | E-03 (61行目) | ○ |
| C-02 | フィーチャーフラグ `passkeys` で制御される | E-02 (74行目) | ○ |
| C-03 | パスワード認証が有効な場合のみ利用可能 | E-02 (75行目) | ○ |
| C-04 | 機能無効時は403 Forbiddenを返却 | E-02 (78行目 render_403) | ○ |
| C-05 | `#js-passkey-authentication` がマウントポイント | E-01 (4行目) | ○ |
| C-06 | `passkey_authentication_data(params)` がデータを提供 | E-01 (4行目) | ○ |
| C-07 | スクリーンリーダー用タイトル「Sign in with passkeys」 | E-01 (1-2行目) | ○ |
| C-08 | 関連機能No.79が正しくマッピングされている | E-04 (14行目) | ○ |
| C-09 | 画面遷移（ダッシュボードへの遷移）が正しい | E-06 (69-70行目) | ○ |
| C-10 | handle_passwordless_flowが呼び出される | E-02 (76行目) | ○ |
| C-11 | h1タグがスクリーンリーダー専用（sr-only） | E-01 (1行目) | ○ |
| C-12 | Remember meがパラメータとして引き継がれる | E-01 (4行目 params参照) | ○ |
| C-13 | device_responseで認証レスポンスが送信される | E-02 (246-248行目 passwordless_passkey_params) | ○ |
| C-14 | クロスプラットフォームPasskeyに対応 | **根拠なし**（WebAuthn仕様だが、実装詳細未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- **C-14**: クロスプラットフォームPasskey（iCloud Keychain、Google Password Manager等）への対応はWebAuthn標準仕様に基づくが、GitLabの具体的な実装設定は未確認
  - 候補：フロントエンドJavaScriptコード / WebAuthn設定ファイル

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: サーバーサイドの主要ロジックはソースコードで確認済み
- **1（中リスク）**: フロントエンドJavaScriptの詳細実装は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] フィーチャーフラグ `passkeys` の有効化状況を確認
- [ ] WebAuthnのJavaScript実装を確認
- [ ] サポートされるオーセンティケーターの種類を確認
- [ ] Discoverable Credentials設定を確認
