---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：81-デプロイ詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **手動デプロイ実行時の具体的なMutation名**：GraphQL Mutationの正確な名称要確認
  2. **承認成功時のメッセージ**：EE機能のため確認困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/deployment.rb` (Deploymentモデル定義)
- E-02: `app/controllers/projects/deployments_controller.rb` (コントローラー)
- E-03: `app/views/projects/deployments/show.html.haml` (ビューテンプレート)
- E-04: `app/assets/javascripts/deployments/components/show_deployment.vue` (Vueコンポーネント)
- E-05: `app/graphql/types/deployment_type.rb` (GraphQL型定義)
- E-06: `app/assets/javascripts/deployments/graphql/queries/deployment.query.graphql` (GraphQLクエリ)
- E-07: `config/routes/project.rb` (ルーティング定義)
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLパターンが `/:namespace/:project/-/environments/:environment_id/deployments/:deployment_iid` | E-07 (350行目 `resources :deployments, only: [:index, :show]`) | ○ |
| C-02 | コントローラーが `Projects::DeploymentsController` | E-02 (3行目) | ○ |
| C-03 | `authorize_read_deployment!` で認可チェック | E-02 (4行目) | ○ |
| C-04 | `project.deployments.find_by_iid!` でデプロイメント取得 | E-02 (25行目) | ○ |
| C-05 | Deploymentモデルに `state_machine :status` がある | E-01 (77-148行目) | ○ |
| C-06 | ステータスが created/running/success/failed/canceled/blocked | E-01 (158-166行目 `enum :status`) | ○ |
| C-07 | Vue.jsコンポーネントが `show_deployment.vue` | E-04 (全体) | ○ |
| C-08 | Apollo Clientで3秒ポーリング | E-04 (14行目 `DEPLOYMENT_QUERY_POLLING_INTERVAL = 3000`) | ○ |
| C-09 | GraphQLクエリで deployment.status, ref, tag 等を取得 | E-06 (11-14行目) | ○ |
| C-10 | commit情報（shortId, title, authorName等）を取得 | E-06 (29-40行目) | ○ |
| C-11 | triggerer (実行ユーザー) を取得 | E-06 (41-43行目) | ○ |
| C-12 | tags配列を取得 | E-06 (15-19行目) | ○ |
| C-13 | userPermissions.updateDeploymentを取得 | E-06 (46-48行目) | ○ |
| C-14 | Protected Environments設定パスが条件付きで設定される | E-03 (11行目) | ○ |
| C-15 | `admin_pipeline`権限チェックでリンク表示制御 | E-03 (11行目 `can?(current_user, :admin_pipeline, @project)`) | ○ |
| C-16 | graphql_etag_keyでキャッシュ制御 | E-03 (9行目) | ○ |
| C-17 | Deploymentは project, environment に belongs_to | E-01 (21-22行目) | ○ |
| C-18 | Deploymentは merge_requests と has_many through | E-01 (26-27行目) | ○ |
| C-19 | deployment.job で CI::Processable を取得 | E-01 (226-228行目) | ○ |
| C-20 | deployed_by メソッドでトリガーユーザーを取得 | E-01 (358-364行目) | ○ |
| C-21 | GraphQL DeploymentTypeで triggerer フィールドを deployed_by で解決 | E-05 (64-67行目) | ○ |
| C-22 | エラーメッセージ「There was an issue fetching the deployment...」 | E-04 (104-106行目) | ○ |
| C-23 | 手動デプロイ実行時のMutation名が `ciJobPlay` | **根拠なし** | △ |
| C-24 | 承認成功メッセージ「Deployment approved successfully」 | **根拠なし** | △ |
| C-25 | 関連機能No.56がデプロイメント履歴 | E-08 (120行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 手動デプロイ実行時のMutation名
  - 理由：EEコンポーネント内で定義されている可能性があり、CEリポジトリでは確認困難
  - 候補：`ciJobPlay` / `playJob` / `runJob`
- 承認操作のメッセージ
  - 理由：EE機能のコンポーネント（`ee_component/deployments/components/deployment_approvals.vue`）のため確認困難
  - 候補：EEリポジトリで確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面の基本構造、データ取得フロー
- 1: 中リスク - Protected Environments関連の機能（EE依存）
- 1: 中リスク - 手動デプロイ実行フローの詳細

## 6) レビュアーチェックリスト（最小）
- [ ] URLパターンとルーティング定義が一致しているか確認
- [ ] ステータスの状態遷移が正確に記述されているか確認
- [ ] 権限チェックの条件が正しく記載されているか確認
- [ ] EE機能の記述が適切にマークされているか確認
- [ ] 手動デプロイ実行のMutation名を実際のコードで確認
