---
generated_at: 2026-01-22 12:05:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：82-フィーチャーフラグ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **Vuexストアの実装詳細**：ストアファイルの直接確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/operations/feature_flag.rb` (FeatureFlagモデル定義)
- E-02: `app/controllers/projects/feature_flags_controller.rb` (コントローラー)
- E-03: `app/views/projects/feature_flags/index.html.haml` (ビューテンプレート)
- E-04: `app/assets/javascripts/feature_flags/components/feature_flags.vue` (Vueコンポーネント)
- E-05: `app/assets/javascripts/feature_flags/components/feature_flags_table.vue` (テーブルコンポーネント)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンが `/:namespace/:project/-/feature_flags` | E-02 (resourcesルートから推定) | ○ |
| C-02 | コントローラーが `Projects::FeatureFlagsController` | E-02 (3行目) | ○ |
| C-03 | `authorize_read_feature_flag!` で認可チェック | E-02 (6行目) | ○ |
| C-04 | ページネーションが30件/ページ | E-02 (20-21行目 `.page(params[:page]).per(30)`) | ○ |
| C-05 | 10秒ポーリング設定 | E-02 (26行目 `Gitlab::PollingInterval.set_header(response, interval: 10_000)`) | ○ |
| C-06 | FeatureFlagモデルはoperations_feature_flagsテーブルを使用 | E-01 (11行目 `self.table_name = 'operations_feature_flags'`) | ○ |
| C-07 | name属性は2-63文字、特定のフォーマット制約 | E-01 (28-36行目 validates :name) | ○ |
| C-08 | strategiesとのhas_many関連 | E-01 (23行目) | ○ |
| C-09 | Vueコンポーネントがfeature_flags.vue | E-04 (全体) | ○ |
| C-10 | テーブル列がID, Status, Feature flag, Environment Specs, Actions | E-05 (52-76行目 tableFields) | ○ |
| C-11 | トグル操作でactive状態を反転 | E-05 (111-116行目 toggleFeatureFlag) | ○ |
| C-12 | 削除確認モーダルを表示 | E-05 (255-270行目 GlModal) | ○ |
| C-13 | 削除時にDELETEメソッドでフォーム送信 | E-05 (267行目 `method="delete"`) | ○ |
| C-14 | 上限到達時に警告アラート表示 | E-04 (157-169行目) | ○ |
| C-15 | featureFlagsLimitでバッジ表示制御 | E-04 (91-95行目 countBadgeContents) | ○ |
| C-16 | canUserConfigureでConfigureボタン表示制御 | E-04 (211-219行目) | ○ |
| C-17 | hasNewPathでNew feature flagボタン表示制御 | E-04 (221-229行目) | ○ |
| C-18 | userListPathでView user listsボタン表示制御 | E-04 (202-210行目) | ○ |
| C-19 | ビューテンプレートでdata属性にendpoint等を設定 | E-03 (3-17行目) | ○ |
| C-20 | admin_feature_flag権限でConfigureボタン | E-03 (14行目 `can-user-admin-feature-flag`) | ○ |
| C-21 | admin_feature_flags_client権限でローテーション | E-03 (16行目) | ○ |
| C-22 | admin_feature_flags_user_lists権限でユーザーリストボタン | E-03 (17行目) | ○ |
| C-23 | 関連機能No.59がフィーチャーフラグ | E-06 (121-123行目) | ○ |
| C-24 | Vuex storeでfetchFeatureFlagsアクション実行 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vuexストアの実装詳細
  - 理由：`app/assets/javascripts/feature_flags/store/`ディレクトリ内のファイルを直接確認していない
  - 候補：store/index.js / store/actions.js / store/mutations.js

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面の基本構造、テーブル表示
- 0: 低リスク - 認可チェック、権限制御
- 1: 中リスク - Vuexストアの状態管理フロー詳細

## 6) レビュアーチェックリスト（最小）
- [ ] 認可チェックの権限名が正しいか確認
- [ ] ページネーション件数（30件）が正しいか確認
- [ ] ポーリング間隔（10秒）が正しいか確認
- [ ] テーブル列の順序と名称が正しいか確認
- [ ] Vuexストア実装を直接確認してフローを検証
