---
generated_at: 2026-01-22 12:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：83-フィーチャーフラグ新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **CreateServiceの詳細処理**：サービスクラスの実装詳細は直接確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/operations/feature_flag.rb` (FeatureFlagモデル定義)
- E-02: `app/controllers/projects/feature_flags_controller.rb` (コントローラー)
- E-03: `app/views/projects/feature_flags/new.html.haml` (ビューテンプレート)
- E-04: `app/assets/javascripts/feature_flags/components/new_feature_flag.vue` (Vueコンポーネント)
- E-05: `app/assets/javascripts/feature_flags/components/form.vue` (フォームコンポーネント)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンが `/:namespace/:project/-/feature_flags/new` | E-02 (resourcesルートから推定) | ○ |
| C-02 | `authorize_create_feature_flag!`で認可チェック | E-02 (7行目) | ○ |
| C-03 | 名前は2-63文字のバリデーション | E-01 (29行目 `length: 2..63`) | ○ |
| C-04 | 名前のフォーマット正規表現制約 | E-01 (30-35行目 format validation) | ○ |
| C-05 | descriptionは最大255文字 | E-01 (38行目) | ○ |
| C-06 | activeのデフォルト値がtrue | E-01 (19行目) | ○ |
| C-07 | versionのデフォルト値がnew_version_flag | E-01 (20行目) | ○ |
| C-08 | accepts_nested_attributes_for :strategies | E-01 (40行目) | ○ |
| C-09 | 初期戦略がROLLOUT_STRATEGY_ALL_USERS | E-04 (17-19行目) | ○ |
| C-10 | createFeatureFlagアクションを呼び出し | E-04 (22行目, 38行目) | ○ |
| C-11 | フォームでname, description, strategies等を収集 | E-05 (123-130行目) | ○ |
| C-12 | handleSubmitでformデータをemit | E-05 (132行目) | ○ |
| C-13 | Name入力フィールドにrequired属性 | E-05 (160-161行目) | ○ |
| C-14 | addStrategyでデフォルト戦略を追加 | E-05 (107-109行目) | ○ |
| C-15 | deleteStrategyで戦略を削除 | E-05 (111-117行目) | ○ |
| C-16 | 戦略0件時に「Feature Flag has no strategies」表示 | E-05 (207-209行目) | ○ |
| C-17 | Cancelボタンでpath（一覧）へ遷移 | E-05 (221行目) | ○ |
| C-18 | ビューでdata属性にendpoint等を設定 | E-03 (6-14行目) | ○ |
| C-19 | FeatureFlags::CreateServiceを使用 | E-02 (46行目) | ○ |
| C-20 | CreateServiceの詳細処理フロー | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- CreateServiceの詳細処理
  - 理由：`app/services/feature_flags/create_service.rb`を直接読み込んでいない
  - 候補：create_service.rb / base_service.rb

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 入力フォームの構造、バリデーション
- 0: 低リスク - デフォルト値の設定
- 1: 中リスク - サービス層の詳細処理フロー

## 6) レビュアーチェックリスト（最小）
- [ ] 名前のバリデーション制約（2-63文字、フォーマット）が正しいか確認
- [ ] デフォルト戦略の設定が正しいか確認
- [ ] CreateServiceの実装を直接確認して処理フローを検証
- [ ] エラーメッセージの内容を実際の動作で確認
