---
generated_at: 2026-01-22 12:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：85-リリース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **フロントエンドVueコンポーネント**：Vueファイルを直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/release.rb` (Releaseモデル定義)
- E-02: `app/controllers/projects/releases_controller.rb` (コントローラー)
- E-03: `app/views/projects/releases/index.html.haml` (ビューテンプレート)
- E-04: `app/helpers/releases_helper.rb` (ヘルパー)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンが `/:namespace/:project/-/releases` | E-02 (resourcesルート) | ○ |
| C-02 | `authorize_read_release!`で認可チェック | E-02 (7行目) | ○ |
| C-03 | HTML/JSON/ATOMに対応 | E-02 (20-32行目 respond_to) | ○ |
| C-04 | create_release権限で新規作成ボタン表示制御 | E-04 (22-24行目) | ○ |
| C-05 | data_for_releases_pageでVueにデータ渡し | E-04 (14-26行目) | ○ |
| C-06 | project_id, project_pathをdataに含む | E-04 (16-17行目) | ○ |
| C-07 | atom_feed_pathをdataに含む | E-04 (20行目) | ○ |
| C-08 | デフォルトソートがRELEASED_AT_DESC | E-04 (8行目) | ○ |
| C-09 | 起動時クエリ最適化が実装されている | E-04 (29-31行目 use_startup_query_for_index_page?) | ○ |
| C-10 | Releaseモデルがtagで識別される | E-01 (116-118行目 to_param) | ○ |
| C-11 | Releaseがlinksとのアソシエーションを持つ | E-01 (17-18行目) | ○ |
| C-12 | Releaseがmilestonesとのアソシエーションを持つ | E-01 (20-21行目) | ○ |
| C-13 | Releaseがevidencesとのアソシエーションを持つ | E-01 (22行目) | ○ |
| C-14 | upcoming_release?で将来リリース判定 | E-01 (139-141行目) | ○ |
| C-15 | name属性がなければtagを返す | E-01 (147-149行目) | ○ |
| C-16 | 関連機能No.73がリリース作成 | E-05 (124行目) | ○ |
| C-17 | ビューでdata_for_releases_pageを使用 | E-03 (9行目) | ○ |
| C-18 | Vue/GraphQL実装の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- フロントエンドVueコンポーネントの詳細
  - 理由：`app/assets/javascripts/releases/components/`内のVueファイルを直接確認していない
  - 候補：releases_index_app.vue / release_block.vue

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 認可チェック、データ渡し
- 0: 低リスク - モデル構造、アソシエーション
- 1: 中リスク - フロントエンド実装詳細

## 6) レビュアーチェックリスト（最小）
- [ ] 認可チェック（read_release権限）が正しいか確認
- [ ] ATOMフィードが正しく生成されるか確認
- [ ] Vue/GraphQLの実装を直接確認してデータフローを検証
- [ ] ページネーションの動作を確認
