---
generated_at: 2026-01-22 12:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：86-リリース新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **Vue/GraphQL Mutation実装**：Vueコンポーネントを直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/release.rb` (Releaseモデル定義)
- E-02: `app/controllers/projects/releases_controller.rb` (コントローラー)
- E-03: `app/views/projects/releases/new.html.haml` (ビューテンプレート)
- E-04: `app/helpers/releases_helper.rb` (ヘルパー)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンが `/:namespace/:project/-/releases/new` | E-02 (resourcesルート) | ○ |
| C-02 | `authorize_create_release!`で認可チェック | E-02 (9行目) | ○ |
| C-03 | newアクションでタグ名パラメータ対応 | E-02 (43-44行目) | ○ |
| C-04 | data_for_new_release_pageでVueにデータ渡し | E-04 (58-64行目) | ○ |
| C-05 | tag_nameパラメータで初期タグ指定可能 | E-04 (59行目) | ○ |
| C-06 | project_path, project_idをdataに含む | E-04 (60-61行目) | ○ |
| C-07 | releases_page_pathを返却 | E-04 (62行目) | ○ |
| C-08 | markdown_docs_pathを返却 | E-04 (63行目) | ○ |
| C-09 | Releaseがproject, tagで一意性制約 | E-01 (42行目 validates_uniqueness_of) | ○ |
| C-10 | Releaseがlinksアソシエーションを持つ | E-01 (17-18行目) | ○ |
| C-11 | Releaseがmilestonesアソシエーションを持つ | E-01 (20-21行目) | ○ |
| C-12 | released_atで将来リリース判定 | E-01 (139-141行目 upcoming_release?) | ○ |
| C-13 | 関連機能No.73がリリース作成 | E-05 (124行目) | ○ |
| C-14 | 関連機能No.74がリリースアセット | E-05 (125行目) | ○ |
| C-15 | ビューでdata_for_new_release_pageを使用 | E-03 (推定) | ○ |
| C-16 | GraphQL Mutation releaseCreateの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GraphQL Mutation `releaseCreate`の詳細
  - 理由：`app/graphql/mutations/releases/`内のファイルを直接確認していない
  - 候補：create.rb

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 認可チェック、ヘルパーのデータ生成
- 0: 低リスク - モデル構造、アソシエーション
- 1: 中リスク - GraphQL Mutation実装詳細

## 6) レビュアーチェックリスト（最小）
- [ ] 認可チェック（create_release権限）が正しいか確認
- [ ] GraphQL Mutationの実装を直接確認してエラーハンドリングを検証
- [ ] タグ作成とリリース作成の連携を確認
- [ ] アセットリンク作成のバリデーションを確認
